/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.kantan;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.kantan.KantanMTConnectorParameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryUtil;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class KantanMTConnector
extends BaseConnector {
    private Logger logger = LoggerFactory.getLogger(KantanMTConnector.class);
    private static final String API_SERVER_URL = "https://www.kantanmt.com/api/xlate";
    private static final String CONNECTOR_ERROR = "KantanMT Connector Error: %s";
    private static final int CONNECTION_TIMEOUT_MS = 10000;
    private static final int SOCKET_TIMEOUT_MS = 0;
    private static final int DEFAULT_FUZZY_SCORE = 95;
    private static final int MAX_SEGMENTS = 900;
    private KantanMTConnectorParameters parameters;
    private JSONParser parser;
    private HttpClient httpClient;
    private List<QueryResult> results = new ArrayList<QueryResult>();

    public KantanMTConnector() {
        this.parameters = new KantanMTConnectorParameters();
        this.parser = new JSONParser();
        this.httpClient = new DefaultHttpClient();
    }

    protected String getServerURL() {
        return API_SERVER_URL;
    }

    protected int getConnectionTimeout() {
        return 10000;
    }

    protected int getSocketTimeout() {
        return 0;
    }

    public String getName() {
        return "KantanMT v1 (deprecated)";
    }

    public String getSettingsDisplay() {
        String profile;
        String string = profile = this.parameters != null ? this.parameters.getProfileName() : "";
        if (!Util.isEmpty((String)profile)) {
            return "Using profile \"" + profile + "\".";
        }
        return "No profile selected.";
    }

    public void open() {
    }

    public void close() {
    }

    public IParameters getParameters() {
        return this.parameters;
    }

    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    public int query(TextFragment tf) {
        this.results = this.batchQuery(Collections.singletonList(tf)).get(0);
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        ArrayList<List<QueryResult>> results = new ArrayList<List<QueryResult>>();
        try {
            if (Util.isEmpty((String)this.parameters.getApiToken()) || Util.isEmpty((String)this.parameters.getProfileName())) {
                throw new OkapiException("You must specify Profile Name and Authorization Token to use this connector");
            }
            HttpPost post = new HttpPost(this.getServerURL());
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpClient.getParams(), (int)this.getConnectionTimeout());
            HttpConnectionParams.setSoTimeout((HttpParams)this.httpClient.getParams(), (int)this.getSocketTimeout());
            post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<RequestInfo> requests = new ArrayList<RequestInfo>();
            for (TextFragment fragment : fragments) {
                requests.add(new RequestInfo(fragment));
            }
            List<UrlEncodedFormEntity> forms = this.fragmentsToPostForms(requests);
            for (UrlEncodedFormEntity form : forms) {
                post.setEntity((HttpEntity)form);
                HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
                StatusLine status = response.getStatusLine();
                if (status == null) {
                    this.logger.error("Unable to get response status code from Kantan API");
                    throw new OkapiException(String.format(CONNECTOR_ERROR, "unable to get response status code"));
                }
                int code = status.getStatusCode();
                String content = this.getResponseContent(response);
                if (content == null || content.length() == 0) {
                    this.logger.error(String.format("Unable to get response content from Kantan API. Response code %d", code));
                    throw new OkapiException(String.format(CONNECTOR_ERROR, "missing response content, status code: " + code));
                }
                if (code != 200) {
                    this.logger.error(String.format("Error in communication with a remote server, status code => %d, response body => %s", code, content));
                    String e = code == 401 ? "Translation request is not authorized. Please, verify your Kantan profile name and authorization token" : "Remote server responded with " + code + " status code";
                    throw new OkapiException(e);
                }
                this.processResponse(requests, results, content);
            }
            this.httpClient.getConnectionManager().shutdown();
        }
        catch (ParseException e) {
            this.logger.error("Cannot parse json response from KantanMT", (Throwable)e);
            throw new OkapiException("Cannot parse json response from Kantan MT. " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Error in communication with Kantan MT server", (Throwable)e);
            throw new OkapiException("Error in communication with Kantan MT server: " + e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private void processResponse(List<RequestInfo> requests, List<List<QueryResult>> results, String content) throws ParseException {
        JSONObject object = (JSONObject)this.parser.parse(content);
        Map map = (Map)object.get((Object)"response");
        String type = (String)map.get("type");
        JSONObject bodyObj = (JSONObject)map.get("body");
        if (type.equals("translation")) {
            JSONArray translations = (JSONArray)bodyObj.get((Object)"translationData");
            for (Object translation : translations) {
                JSONObject transObj = (JSONObject)translation;
                long id = (Long)transObj.get((Object)"id");
                if (id >= (long)requests.size() || id < 0L) {
                    String m = "source fragment for translation with id '" + id + "' was not found";
                    this.logger.error(m);
                    throw new OkapiException(m);
                }
                RequestInfo request = requests.get((int)id);
                ArrayList<QueryResult> qrList = new ArrayList<QueryResult>();
                this.result = new QueryResult();
                this.result.weight = this.getWeight();
                this.result.origin = this.getName();
                this.result.source = request.originalFragment;
                this.result.matchType = MatchType.MT;
                this.result.setFuzzyScore(95);
                if (!request.originalFragment.hasText(false)) {
                    this.result.target = request.originalFragment.clone();
                } else {
                    String translatedText = (String)transObj.get((Object)"trg");
                    translatedText = translatedText.replaceAll("&amp;", "&");
                    this.result.target = request.generateResult(translatedText);
                }
                qrList.add(this.result);
                results.add(qrList);
            }
        } else {
            if (type.equals("status")) {
                String state = (String)bodyObj.get((Object)"state");
                String m = String.format(CONNECTOR_ERROR, "server is in '" + state + "' state");
                throw new OkapiException(m);
            }
            String m = String.format("Server returned JSON response with unprocessible type value '%s'", type);
            this.logger.error(m);
            throw new OkapiException(m);
        }
    }

    private List<UrlEncodedFormEntity> fragmentsToPostForms(List<RequestInfo> requests) {
        ArrayList<UrlEncodedFormEntity> forms = new ArrayList<UrlEncodedFormEntity>();
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("auth", this.parameters.getApiToken()));
        pairs.add(new BasicNameValuePair("profile", this.parameters.getProfileName()));
        for (int i = 0; i < requests.size(); ++i) {
            RequestInfo request = requests.get(i);
            if (!request.originalFragment.hasText(false)) continue;
            String text = request.preparedText.replaceAll("&", "%26");
            if (pairs.size() >= 900) {
                forms.add(new UrlEncodedFormEntity(pairs, Consts.UTF_8));
                pairs = new ArrayList();
                pairs.add(new BasicNameValuePair("auth", this.parameters.getApiToken()));
                pairs.add(new BasicNameValuePair("profile", this.parameters.getProfileName()));
            }
            pairs.add(new BasicNameValuePair(Integer.toString(i), text));
        }
        forms.add(new UrlEncodedFormEntity(pairs, Consts.UTF_8));
        return forms;
    }

    private String getResponseContent(HttpResponse response) throws IOException {
        InputStream stream = response.getEntity().getContent();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
        String responseBody = br.readLine();
        stream.close();
        return responseBody;
    }

    private static class RequestInfo {
        private TextFragment originalFragment;
        private String preparedText;
        private QueryUtil queryUtil = new QueryUtil();

        RequestInfo(TextFragment fragment) {
            this.originalFragment = fragment;
            this.preparedText = this.queryUtil.separateCodesFromText(this.originalFragment);
        }

        TextFragment generateResult(String translated) {
            return this.queryUtil.createNewFragmentWithCodes(translated);
        }
    }
}

