/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.googleautoml;

import java.io.IOException;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.InvalidContentException;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.googleautoml.GoogleAutoMLTranslationAPI;
import net.sf.okapi.connectors.googleautoml.GoogleAutoMLTranslationAPIImpl;
import net.sf.okapi.connectors.googleautoml.GoogleAutoMLTranslationParameters;
import net.sf.okapi.connectors.googleautoml.GoogleOAuth2Service;
import net.sf.okapi.connectors.googleautoml.util.ModelMapUtil;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryUtil;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAutoMLTranslationConnector
extends BaseConnector {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleAutoMLTranslationConnector.class);
    private static final String BASE_URL = "https://automl.googleapis.com/v1beta1";
    private final GoogleAutoMLTranslationAPI api = new GoogleAutoMLTranslationAPIImpl("https://automl.googleapis.com/v1beta1");
    private final GoogleOAuth2Service service = new GoogleOAuth2Service();
    private final ModelMapUtil modelMapUtil = new ModelMapUtil();
    private final QueryUtil queryUtil = new QueryUtil();
    private GoogleAutoMLTranslationParameters params = new GoogleAutoMLTranslationParameters();

    public GoogleAutoMLTranslationParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (GoogleAutoMLTranslationParameters)params;
    }

    public String getName() {
        return "Google AutoML Translation";
    }

    public String getSettingsDisplay() {
        return "Server: https://automl.googleapis.com/v1beta1";
    }

    public void open() {
    }

    public void close() {
    }

    public int query(String plainText) {
        this.checkConnector();
        if (plainText.isEmpty()) {
            return 0;
        }
        try {
            String modelResourceName = this.modelMapUtil.getModelResourceName(this.srcCode, this.trgCode);
            String translation = this.api.predict(plainText, modelResourceName, this.service);
            this.current = 0;
            this.result = this.getQueryResult(plainText, translation, null);
            return 1;
        }
        catch (IOException | ParseException e) {
            throw new OkapiException(e);
        }
    }

    public int query(TextFragment sourceFragment) {
        this.checkConnector();
        if (sourceFragment.isEmpty()) {
            return 0;
        }
        try {
            String modelResourceName = this.modelMapUtil.getModelResourceName(this.srcCode, this.trgCode);
            String htmlText = this.queryUtil.toCodedHTML(sourceFragment);
            String translation = this.api.predict(htmlText, modelResourceName, this.service);
            this.current = 0;
            this.result = this.getQueryResult(htmlText, translation, sourceFragment);
            return 1;
        }
        catch (IOException | ParseException e) {
            throw new OkapiException(e);
        }
    }

    private void checkConnector() {
        if (Util.isEmpty((String)this.params.getModelMap())) {
            throw new OkapiException("This connector requires a mapping from language pairs to models.");
        }
        this.modelMapUtil.setMap(this.params.getModelMap());
        if (!this.service.hasCredential()) {
            if (!Util.isEmpty((String)this.params.getCredentialFilePath())) {
                this.service.setCredentialFilePath(this.params.getCredentialFilePath());
            } else if (!Util.isEmpty((String)this.params.getCredentialString())) {
                this.service.setCredentialString(this.params.getCredentialString());
            } else {
                throw new OkapiException("This connector requires credentials for a Google service account.");
            }
        }
    }

    private QueryResult getQueryResult(String sourceText, String targetText, TextFragment sourceFragment) {
        QueryResult qr = new QueryResult();
        qr.setFuzzyScore(95);
        qr.setCombinedScore(95);
        qr.weight = this.getWeight();
        qr.origin = this.getName();
        qr.matchType = MatchType.MT;
        if (sourceFragment == null) {
            qr.source = new TextFragment(sourceText);
            qr.target = new TextFragment(targetText);
        } else {
            try {
                qr.source = sourceFragment;
                qr.target = this.makeFragment(targetText, sourceFragment);
            }
            catch (InvalidContentException e) {
                LOG.error("This MT candidate will be ignored.\n{}\n{}", (Object)sourceText, (Object)e.getMessage());
                qr.setFuzzyScore(0);
                qr.setCombinedScore(0);
                qr.source = sourceFragment;
                qr.target = sourceFragment.clone();
                qr.setQuality(QueryResult.QUALITY_UNDEFINED);
            }
        }
        return qr;
    }

    private TextFragment makeFragment(String codedHtml, TextFragment sourceFragment) {
        return sourceFragment.hasCode() ? new TextFragment(this.queryUtil.fromCodedHTML(codedHtml, sourceFragment, false), sourceFragment.getClonedCodes()) : new TextFragment(this.queryUtil.fromCodedHTML(codedHtml, sourceFragment, false));
    }
}

