/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.googleautoml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.connectors.googleautoml.GoogleAutoMLTranslationAPI;
import net.sf.okapi.connectors.googleautoml.GoogleOAuth2Service;
import net.sf.okapi.connectors.googleautoml.util.PredictAPIUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAutoMLTranslationAPIImpl
implements GoogleAutoMLTranslationAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleAutoMLTranslationAPIImpl.class);
    private final String baseUrl;
    private final PredictAPIUtil predictApiUtil;

    public GoogleAutoMLTranslationAPIImpl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.predictApiUtil = new PredictAPIUtil();
    }

    @Override
    public String predict(String sourceText, String modelResourceName, GoogleOAuth2Service service) throws IOException, ParseException {
        ArrayList<String> translations = new ArrayList<String>();
        List<JSONObject> requests = this.predictApiUtil.getPredictRequests(sourceText);
        for (JSONObject request : requests) {
            URL url = new URL(String.format("%s/%s:predict", this.baseUrl, modelResourceName));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + service.getAccessToken());
            conn.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
                writer.write(request.toJSONString());
            }
            if (conn.getResponseCode() == 200) {
                translations.add(this.predictApiUtil.extractTranslation(conn.getInputStream()));
                continue;
            }
            String msg = StreamUtil.streamUtf8AsString((InputStream)conn.getErrorStream());
            LOG.info("Error during AutoML predict call: {}", (Object)msg);
            throw new OkapiException(msg);
        }
        StringBuilder translationBuilder = new StringBuilder();
        for (String translation : translations) {
            translationBuilder.append(translation);
        }
        return translationBuilder.toString();
    }
}

