/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.googleautoml.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.sf.okapi.connectors.googleautoml.util.PredictAPIUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PredictAPIUtilTest {
    private PredictAPIUtil util;

    @Before
    public void setup() {
        this.util = new PredictAPIUtil();
    }

    @Test
    public void testGetPredictRequestsNoSplit() {
        String sourceText = "Source text";
        List predictRequests = this.util.getPredictRequests(sourceText);
        Assert.assertEquals((long)1L, (long)predictRequests.size());
        Assert.assertTrue((boolean)((JSONObject)predictRequests.get(0)).toJSONString().contains(String.format("\"content\":\"%s\"", sourceText)));
    }

    @Test
    public void testGetPredictRequestsWithSplit() {
        String part1 = this.getRepeatedString(250000, 'a');
        String part2 = this.getRepeatedString(125000, 'b');
        String sourceText = part1 + part2;
        List predictRequests = this.util.getPredictRequests(sourceText);
        Assert.assertEquals((long)2L, (long)predictRequests.size());
        Assert.assertTrue((boolean)((JSONObject)predictRequests.get(0)).toJSONString().contains(String.format("\"content\":\"%s\"", part1)));
        Assert.assertTrue((boolean)((JSONObject)predictRequests.get(1)).toJSONString().contains(String.format("\"content\":\"%s\"", part2)));
    }

    @Test
    public void testExtractTranslation() throws ParseException {
        String json = "{\"payload\":[{\"translation\":{\"translatedContent\":{\"content\":\"Hello world!\"}}}]}";
        Assert.assertEquals((Object)"Hello world!", (Object)this.util.extractTranslation((InputStream)new ByteArrayInputStream(json.getBytes())));
    }

    private String getRepeatedString(int n, char c) {
        char[] array = new char[n];
        Arrays.fill(array, c);
        return new String(array);
    }
}

