/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.googleautoml.util;

import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.connectors.googleautoml.util.ModelMapUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModelMapUtilTest {
    private ModelMapUtil util;

    @Before
    public void setup() {
        this.util = new ModelMapUtil();
    }

    @Test
    public void testGetModelResourceName() {
        String modelMap = "{\"en-US/ja-JP\": \"projects/my-project/locations/us-central1/models/ABC123\", \"en-US/de-DE\": \"projects/my-project/locations/us-central1/models/DEF456\"}";
        this.util.setMap(modelMap);
        Assert.assertEquals((Object)"projects/my-project/locations/us-central1/models/ABC123", (Object)this.util.getModelResourceName("en-US", "ja-JP"));
        Assert.assertEquals((Object)"projects/my-project/locations/us-central1/models/DEF456", (Object)this.util.getModelResourceName("en-US", "de-DE"));
        Assert.assertEquals((Object)"projects/my-project/locations/us-central1/models/DEF456", (Object)this.util.getModelResourceName("eN-us", "DE-de"));
    }

    @Test(expected=OkapiException.class)
    public void testGetModelResourceNameFailure() {
        String modelMap = "{\"en-US/ja-JP\": \"projects/my-project/locations/us-central1/models/ABC123\", \"en-US/de-DE\": \"projects/my-project/locations/us-central1/models/DEF456\"}";
        this.util.setMap(modelMap);
        this.util.getModelResourceName("en-US", "fr-FR");
    }
}

