/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.deepl;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.deepl.DeepLv1ConnectorParameters;
import net.sf.okapi.lib.translation.BaseConnector;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepLv1Connector
extends BaseConnector {
    private int maxTextParameters = 50;
    private int maxRequestSize = 28000;
    private List<List<TextFragment>> fragmentGroups;
    private static String BASEURL = "https://api.deepl.com/v1/translate";
    private Logger logger = LoggerFactory.getLogger(DeepLv1Connector.class);
    private final Pattern[] patterns;
    private CloseableHttpClient httpClient;
    private List<QueryResult> results;
    private boolean topHitCandidateonly = true;
    private DeepLv1ConnectorParameters params = new DeepLv1ConnectorParameters();

    public DeepLv1Connector() {
        this(null);
    }

    protected DeepLv1Connector(CloseableHttpClient httpClient) {
        this.httpClient = httpClient == null ? HttpClients.createDefault() : httpClient;
        String[] regexs = new String[]{"\\<g-?\\d+?\\>", "\\</g-?\\d+?\\>", "\\<x-?\\d+?/\\>", "\\<b-?\\d+?/\\>", "\\<e-?\\d+?/\\>"};
        this.patterns = new Pattern[regexs.length];
        for (int i = 0; i < regexs.length; ++i) {
            this.patterns[i] = Pattern.compile(regexs[i]);
        }
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public int getMaxTextParameters() {
        return this.maxTextParameters;
    }

    public void setMaxTextParameters(int maxTextParameters) {
        this.maxTextParameters = maxTextParameters;
    }

    public List<List<TextFragment>> getFragmentGroups() {
        return this.fragmentGroups;
    }

    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                this.logger.warn("Error when closing the HTTP client: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public String getName() {
        return "DeepL Connector v1";
    }

    public String getSettingsDisplay() {
        return "DeepL connector v1 - URL: " + BASEURL + " Plain-text: " + (this.params.getPlainText() ? "Yes" : "No");
    }

    public DeepLv1ConnectorParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (DeepLv1ConnectorParameters)params;
    }

    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    public List<List<QueryResult>> batchQuery(List<TextFragment> originalFragmentList) {
        int i;
        ArrayList<List<QueryResult>> masterResults = new ArrayList<List<QueryResult>>();
        this.current = -1;
        this.results = new ArrayList<QueryResult>();
        String text = "";
        String src = this.toInternalCode(this.srcLoc);
        String trg = this.toInternalCode(this.trgLoc);
        String out = null;
        boolean usePlainText = this.params.getPlainText();
        this.fragmentGroups = new ArrayList<List<TextFragment>>();
        ArrayList<TextFragment> fragGroup = new ArrayList<TextFragment>();
        int sizeTracker = 0;
        for (i = 0; i < originalFragmentList.size(); ++i) {
            TextFragment frag = originalFragmentList.get(i);
            if (Util.isEmpty((String)frag.getText())) {
                this.logger.warn("Found empty fragment at index {} in the list of text fragments", (Object)i);
                continue;
            }
            int fragSize = frag.getText().getBytes().length;
            if (fragSize > this.maxRequestSize) {
                this.logger.warn("Found text fragment at index {} that is too large to be processed by DeepL", (Object)i);
                continue;
            }
            if (sizeTracker + fragSize <= this.maxRequestSize && fragGroup.size() + 1 <= this.maxTextParameters) {
                fragGroup.add(frag);
                sizeTracker += fragSize;
            } else {
                this.fragmentGroups.add(fragGroup);
                fragGroup = new ArrayList();
                sizeTracker = 0;
                fragGroup.add(frag);
                sizeTracker += fragSize;
            }
            if (i != originalFragmentList.size() - 1) continue;
            this.fragmentGroups.add(fragGroup);
        }
        for (i = 0; i < this.fragmentGroups.size(); ++i) {
            try {
                List<TextFragment> fragmentGroup = this.fragmentGroups.get(i);
                ArrayList<BasicNameValuePair> reqParams = new ArrayList<BasicNameValuePair>();
                for (TextFragment frag : fragmentGroup) {
                    text = usePlainText ? frag.getText() : GenericContent.fromFragmentToLetterCoded((TextFragment)frag, (boolean)true);
                    reqParams.add(new BasicNameValuePair("text", text));
                }
                reqParams.add(new BasicNameValuePair("auth_key", this.params.getAuthKey()));
                reqParams.add(new BasicNameValuePair("split_sentences", this.params.getSplitSentences() ? "1" : "0"));
                reqParams.add(new BasicNameValuePair("preserve_formatting", this.params.getPreserveFormatting() ? "1" : "0"));
                reqParams.add(new BasicNameValuePair("source_lang", src));
                reqParams.add(new BasicNameValuePair("target_lang", trg));
                if (!usePlainText) {
                    reqParams.add(new BasicNameValuePair("tag_handling", "xml"));
                }
                UrlEncodedFormEntity encodedParams = new UrlEncodedFormEntity(reqParams, "UTF-8");
                HttpPost post = new HttpPost(BASEURL);
                post.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
                post.setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
                post.setEntity((HttpEntity)encodedParams);
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new RuntimeException("HTTP response=" + response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase());
                    }
                    out = this.readContent((HttpResponse)response);
                    ByteArrayInputStream is = new ByteArrayInputStream(out.getBytes(StandardCharsets.UTF_8));
                    JsonReader r = Json.createReaderFactory(null).createReader((InputStream)is, StandardCharsets.UTF_8);
                    JsonObject jo = r.readObject();
                    JsonArray ja = jo.getJsonArray("translations");
                    if (ja == null) {
                        this.logger.warn("DeepL result does not have 'translations'. Response was: {}", (Object)jo.toString());
                        masterResults.add(this.results);
                        continue;
                    }
                    for (int j = 0; j < ja.size(); ++j) {
                        TextFragment origFrag = fragmentGroup.get(j);
                        jo = ja.getJsonObject(j);
                        if (jo == null) continue;
                        String trans = jo.getString("text");
                        if (Util.isEmpty((String)trans)) {
                            this.logger.warn("Empty MT result for source '{}'. Using source.", (Object)origFrag.getText());
                            trans = origFrag.getText();
                        }
                        QueryResult qr = new QueryResult();
                        qr.matchType = MatchType.MT;
                        qr.source = origFrag;
                        if (usePlainText) {
                            qr.target = new TextFragment(trans);
                        } else {
                            trans = this.removeDupeCodes(trans);
                            qr.target = GenericContent.fromLetterCodedToFragment((String)trans, (TextFragment)origFrag.clone(), (boolean)true, (boolean)true);
                        }
                        qr.setFuzzyScore(95);
                        qr.setCombinedScore(95);
                        this.results = new ArrayList<QueryResult>();
                        this.results.add(qr);
                        masterResults.add(this.results);
                    }
                }
                if (this.results.size() <= 0) continue;
                this.current = 0;
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Error: " + e.getMessage() + "\nSource text: " + text + "\nOutput: " + out);
            }
        }
        return masterResults;
    }

    public int query(String text) {
        return this.query(new TextFragment(text));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int query(TextFragment fragment) {
        boolean usePlainText = this.params.getPlainText();
        String text = usePlainText ? fragment.getText() : GenericContent.fromFragmentToLetterCoded((TextFragment)fragment, (boolean)true);
        this.current = -1;
        this.results = new ArrayList<QueryResult>();
        if (text.trim().isEmpty()) {
            return 0;
        }
        String src = this.toInternalCode(this.srcLoc);
        String trg = this.toInternalCode(this.trgLoc);
        String out = null;
        try {
            ArrayList<BasicNameValuePair> reqParams = new ArrayList<BasicNameValuePair>();
            reqParams.add(new BasicNameValuePair("auth_key", this.params.getAuthKey()));
            reqParams.add(new BasicNameValuePair("split_sentences", this.params.getSplitSentences() ? "1" : "0"));
            reqParams.add(new BasicNameValuePair("preserve_formatting", this.params.getPreserveFormatting() ? "1" : "0"));
            reqParams.add(new BasicNameValuePair("source_lang", src));
            reqParams.add(new BasicNameValuePair("target_lang", trg));
            reqParams.add(new BasicNameValuePair("text", text));
            if (!usePlainText) {
                reqParams.add(new BasicNameValuePair("tag_handling", "xml"));
            }
            UrlEncodedFormEntity encodedParams = new UrlEncodedFormEntity(reqParams, "UTF-8");
            HttpPost post = new HttpPost(BASEURL);
            post.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            post.setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
            post.setEntity((HttpEntity)encodedParams);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new RuntimeException("HTTP response=" + response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase());
                }
                out = this.readContent((HttpResponse)response);
                ByteArrayInputStream is = new ByteArrayInputStream(out.getBytes(StandardCharsets.UTF_8));
                JsonReader r = Json.createReaderFactory(null).createReader((InputStream)is, StandardCharsets.UTF_8);
                JsonObject jo = r.readObject();
                JsonArray ja = jo.getJsonArray("translations");
                if (ja == null) {
                    this.logger.warn("DeepL result does not have 'translations'. Query was: {}", (Object)text);
                    int n = 0;
                    return n;
                }
                for (int i = 0; i < ja.size(); ++i) {
                    jo = ja.getJsonObject(i);
                    if (jo == null) {
                        int n = 0;
                        return n;
                    }
                    String trans = jo.getString("text");
                    if (Util.isEmpty((String)trans)) {
                        this.logger.warn("Empty MT result for source '{}'. Using source.", (Object)fragment.getText());
                        trans = fragment.toText();
                    }
                    QueryResult qr = new QueryResult();
                    qr.matchType = MatchType.MT;
                    qr.source = fragment;
                    if (usePlainText) {
                        qr.target = new TextFragment(trans);
                    } else {
                        trans = this.removeDupeCodes(trans);
                        qr.target = GenericContent.fromLetterCodedToFragment((String)trans, (TextFragment)fragment.clone(), (boolean)true, (boolean)true);
                    }
                    qr.setFuzzyScore(95);
                    qr.setCombinedScore(95);
                    this.results.add(qr);
                    if (!this.topHitCandidateonly) {
                        continue;
                    }
                    break;
                }
            }
            if (this.results.size() <= 0) return this.results.size();
            this.current = 0;
            return this.results.size();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error: " + e.getMessage() + "\nSource text: " + text + "\nOutput: " + out);
        }
    }

    private String readContent(HttpResponse response) throws IOException {
        String body = null;
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return "";
        }
        try (InputStream stream = entity.getContent();){
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            body = br.readLine();
        }
        EntityUtils.consume((HttpEntity)entity);
        return body;
    }

    protected String toInternalCode(LocaleId locale) {
        String lang;
        switch (lang = locale.getLanguage().toUpperCase()) {
            case "EN": 
            case "DE": 
            case "FR": 
            case "ES": 
            case "IT": 
            case "NL": 
            case "PL": {
                return lang;
            }
        }
        throw new InvalidParameterException("Unsupported language: " + lang);
    }

    public void open() {
    }

    protected String removeDupeCodes(String dupeCodeText) {
        ArrayList<String> foundCodes = new ArrayList<String>();
        for (Pattern pattern : this.patterns) {
            Matcher mat = pattern.matcher(dupeCodeText);
            while (mat.find()) {
                foundCodes.add(mat.group());
            }
        }
        if (foundCodes.size() == 0) {
            return dupeCodeText;
        }
        HashMap<String, String> seenCodes = new HashMap<String, String>();
        ArrayList<String> dupeCodes = new ArrayList<String>();
        for (String codeVal : foundCodes) {
            if (!seenCodes.containsKey(codeVal)) {
                seenCodes.put(codeVal, codeVal);
                continue;
            }
            dupeCodes.add(codeVal);
        }
        if (dupeCodes.size() == 0) {
            return dupeCodeText;
        }
        for (String dupeCode : dupeCodes) {
            String[] textParts = dupeCodeText.split(dupeCode);
            Object tmpString = "";
            for (int i = 0; i < textParts.length; ++i) {
                String textPart = textParts[i];
                if (i == 0) {
                    if (dupeCodeText.startsWith(dupeCode)) {
                        tmpString = dupeCode + textPart;
                        continue;
                    }
                    tmpString = textPart + dupeCode;
                    continue;
                }
                tmpString = (String)tmpString + textPart;
            }
            dupeCodeText = tmpString;
        }
        return dupeCodeText;
    }
}

