/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.deepl;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.translation.BaseConnector;

@Deprecated
public class DeepLConnector
extends BaseConnector {
    private static String BASEURL = "https://www.deepl.com/jsonrpc";
    private Client client;
    private WebTarget wt;
    private List<QueryResult> results;
    private boolean topHitCandidateonly = true;

    public void close() {
    }

    public String getName() {
        return "DeepL Connector (ALPHA)";
    }

    public String getSettingsDisplay() {
        return "DeepL connector - Alpha - URL: " + BASEURL;
    }

    public void open() {
        this.client = ClientBuilder.newClient();
        this.wt = this.client.target(BASEURL);
    }

    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    public int query(String text) {
        this.current = -1;
        this.results = new ArrayList<QueryResult>();
        if (text.trim().isEmpty()) {
            return 0;
        }
        String src = this.toInternalCode(this.srcLoc);
        String trg = this.toInternalCode(this.trgLoc);
        try {
            JsonArray jaJobs = Json.createArrayBuilder().add((JsonValue)Json.createObjectBuilder().add("kind", "default").add("raw_en_sentence", text).build()).build();
            JsonObject joLang = Json.createObjectBuilder().add("user_preferred_langs", (JsonValue)Json.createArrayBuilder().add(src).add(trg).build()).add("source_lang_user_selected", src).add("target_lang", trg).build();
            JsonObject joParams = Json.createObjectBuilder().add("jobs", (JsonValue)jaJobs).add("lang", (JsonValue)joLang).add("priority", -1).build();
            String json = Json.createObjectBuilder().add("jsonrpc", "2.0").add("method", "LMT_handle_jobs").add("params", (JsonValue)joParams).build().toString();
            Invocation.Builder ib = this.wt.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            Response resp = ib.post(Entity.text((Object)json));
            InputStream is = (InputStream)resp.readEntity(InputStream.class);
            JsonReader r = Json.createReader((InputStream)is);
            JsonObject jo = r.readObject();
            jo = jo.getJsonObject("result");
            if (jo == null) {
                return 0;
            }
            JsonArray ja = jo.getJsonArray("translations");
            if (ja == null) {
                return 0;
            }
            JsonArray beams = ja.getJsonObject(0).getJsonArray("beams");
            for (int i = 0; i < beams.size(); ++i) {
                jo = beams.getJsonObject(i);
                if (jo == null) {
                    return 0;
                }
                String trans = jo.getString("postprocessed_sentence");
                if (Util.isEmpty((String)trans)) continue;
                QueryResult qr = new QueryResult();
                qr.matchType = MatchType.MT;
                qr.source = new TextFragment(text);
                qr.target = new TextFragment(trans);
                qr.setFuzzyScore(95);
                qr.setCombinedScore(95);
                this.results.add(qr);
                if (this.topHitCandidateonly) break;
            }
            if (this.results.size() > 0) {
                this.current = 0;
            }
            return this.results.size();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error: " + e.getMessage() + "\nSource text: " + text);
        }
    }

    public int query(TextFragment fragment) {
        return this.query(fragment.getText());
    }

    protected String toInternalCode(LocaleId locale) {
        String lang;
        switch (lang = locale.getLanguage().toUpperCase()) {
            case "EN": 
            case "DE": 
            case "FR": 
            case "ES": 
            case "IT": 
            case "NL": 
            case "PL": {
                return lang;
            }
        }
        throw new InvalidParameterException("Unsupported language: " + lang);
    }
}

