/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.deepl;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class DeepLv1ConnectorParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String AUTHKEY = "authKey";
    private static final String PLAINTEXT = "plainText";
    private static final String SPLITSENTENCES = "splitSentences";
    private static final String PRESERVEFORMATTING = "preserveFormatting";

    public String getAuthKey() {
        return this.getString(AUTHKEY);
    }

    public void setAuthKey(String authKey) {
        this.setString(AUTHKEY, authKey);
    }

    public boolean getPlainText() {
        return this.getBoolean(PLAINTEXT);
    }

    public void setPlainText(boolean plainText) {
        this.setBoolean(PLAINTEXT, plainText);
    }

    public boolean getSplitSentences() {
        return this.getBoolean(SPLITSENTENCES);
    }

    public void setSplitSentences(boolean splitSentences) {
        this.setBoolean(SPLITSENTENCES, splitSentences);
    }

    public boolean getPreserveFormatting() {
        return this.getBoolean(PRESERVEFORMATTING);
    }

    public void setPreserveFormatting(boolean preserveFormatting) {
        this.setBoolean(PRESERVEFORMATTING, preserveFormatting);
    }

    public void reset() {
        super.reset();
        this.setAuthKey("");
        this.setPlainText(false);
        this.setSplitSentences(false);
        this.setPreserveFormatting(true);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(AUTHKEY, "Authentication Key (Contact Deepl to get one)", "DeepL authentication key");
        desc.add(PLAINTEXT, "Get plain-text translation", "Strips out inline codes and gives plain-text translations");
        desc.add(SPLITSENTENCES, "Split sentences", "Determines if the input is first split into sentences");
        desc.add(PRESERVEFORMATTING, "Preserve some formatting aspects", "Determines if some aspects of formatting are preserved (punctuation, upper/lower case)");
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("DeepL Connector v1 Settings", true, false);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(AUTHKEY));
        tip.setPassword(true);
        desc.addCheckboxPart(paramsDesc.get(PLAINTEXT));
        desc.addCheckboxPart(paramsDesc.get(SPLITSENTENCES));
        desc.addCheckboxPart(paramsDesc.get(PRESERVEFORMATTING));
        return desc;
    }
}

