/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.deepl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.deepl.DeepLv1Connector;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DeepLv1ConnectorMockitoTests {
    @Mock
    private CloseableHttpClient httpClient;
    @InjectMocks
    private DeepLv1Connector connector;

    @Before
    public void setup() {
        this.initConnector();
    }

    private void initConnector() {
        this.connector.getParameters().setAuthKey("fake_token");
    }

    @Test
    public void testQuery() throws IOException {
        CloseableHttpResponse mockResponse = this.mockHttpResponse(200, this.deeplJSONResponse(this.translationDataJSON("EN", Arrays.asList("Translated first fragment"))));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Matchers.any(HttpPost.class))).thenReturn((Object)mockResponse);
        this.connector.setLanguages(LocaleId.ENGLISH, LocaleId.ENGLISH);
        int i = this.connector.query("First fragment");
        Assert.assertEquals((long)1L, (long)i);
        Assert.assertTrue((boolean)this.connector.hasNext());
        Assert.assertEquals((Object)"Translated first fragment", (Object)this.connector.next().target.toString());
    }

    @Test
    public void testQueryWithCodes() throws IOException {
        CloseableHttpResponse mockResponse = this.mockHttpResponse(200, this.deeplJSONResponse(this.translationDataJSON("EN", Arrays.asList("Text in <g1>bold</g1> and a &"))));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Matchers.any(HttpPost.class))).thenReturn((Object)mockResponse);
        this.connector.setLanguages(LocaleId.ENGLISH, LocaleId.ENGLISH);
        TextFragment frag = new TextFragment("Text in ");
        frag.append(TextFragment.TagType.OPENING, "b", "<B>");
        frag.append("bold");
        frag.append(TextFragment.TagType.CLOSING, "b", "</B>");
        frag.append(" and a &");
        int i = this.connector.query(frag);
        Assert.assertEquals((long)1L, (long)i);
        Assert.assertTrue((boolean)this.connector.hasNext());
        TextFragment res = this.connector.next().target;
        Assert.assertEquals((Object)"Text in <B>bold</B> and a &", (Object)res.toText());
    }

    private CloseableHttpResponse mockHttpResponse(int statusCode, String body) throws IOException {
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)statusCode);
        HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)httpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)statusLine);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)httpEntity);
        return response;
    }

    private String translationDataJSON(String srcLang, List<String> transStrings) {
        String templateTranslationData = "\"translations\": [%s]";
        String templateTranslationItem = "{\"detected_source_language\": \"%s\", \"text\": \"%s\"}";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < transStrings.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(String.format(templateTranslationItem, srcLang, transStrings.get(i)));
        }
        return String.format(templateTranslationData, sb.toString());
    }

    private String deeplJSONResponse(String body) {
        return String.format("{%s}", body);
    }
}

