/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.deepl;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.deepl.DeepLv1Connector;
import net.sf.okapi.connectors.deepl.DeepLv1ConnectorParameters;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class DeepLv1ConnectorTests {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEEPLAPIKEY;

    public DeepLv1ConnectorTests() {
        this.DEEPLAPIKEY = null;
    }

    @Test
    public void simpleTest() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters params = conn.getParameters();
        params.setAuthKey(this.DEEPLAPIKEY);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.FRENCH);
        conn.query("This is an example in ASCII with the text \"Open the TC_ROOT\\install\\uninstall.xml file\" and some number of characters that should work just fine.");
        Assert.assertTrue((boolean)conn.hasNext());
        while (conn.hasNext()) {
            QueryResult qr = conn.next();
            this.logger.info("src: {}", (Object)qr.source.toText());
            this.logger.info("trg: {}", (Object)qr.target.toText());
            Assert.assertTrue((boolean)qr.fromMT());
            Assert.assertFalse((boolean)qr.source.toText().equals(qr.target.toText()));
        }
        conn.close();
    }

    @Test
    public void testPlainText() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters params = conn.getParameters();
        params.setAuthKey(this.DEEPLAPIKEY);
        params.setPlainText(true);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.FRENCH);
        TextFragment frag = new TextFragment("This is ");
        frag.append(TextFragment.TagType.OPENING, "bold", "<B>");
        frag.append("bold");
        frag.append(TextFragment.TagType.CLOSING, "bold", "</B>");
        frag.append(" with ");
        frag.append(TextFragment.TagType.PLACEHOLDER, "lb", "<BR/>");
        frag.append(" and an ampersand &");
        conn.query(frag);
        Assert.assertTrue((boolean)conn.hasNext());
        while (conn.hasNext()) {
            QueryResult qr = conn.next();
            this.logQueryResult(qr);
            Assert.assertTrue((boolean)qr.fromMT());
            Assert.assertFalse((boolean)qr.target.hasCode());
            Assert.assertFalse((boolean)qr.source.toText().equals(qr.target.toText()));
        }
        conn.close();
    }

    @Test
    public void testWithCodes() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters params = conn.getParameters();
        params.setAuthKey(this.DEEPLAPIKEY);
        params.setPlainText(false);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.FRENCH);
        TextFragment frag = new TextFragment("This is ");
        frag.append(TextFragment.TagType.OPENING, "bold", "<B>");
        frag.append("bold");
        frag.append(TextFragment.TagType.CLOSING, "bold", "</B>");
        frag.append(" with ");
        frag.append(TextFragment.TagType.PLACEHOLDER, "lb", "<BR/>");
        frag.append(" and an ampersand &");
        conn.query(frag);
        Assert.assertTrue((boolean)conn.hasNext());
        while (conn.hasNext()) {
            QueryResult qr = conn.next();
            this.logQueryResult(qr);
            Assert.assertTrue((boolean)qr.fromMT());
            Assert.assertTrue((boolean)qr.target.hasCode());
            Assert.assertFalse((boolean)qr.source.toText().equals(qr.target.toText()));
        }
        conn.close();
    }

    @Test
    public void testWithCodesForRSIssue() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters params = conn.getParameters();
        params.setAuthKey(this.DEEPLAPIKEY);
        params.setPlainText(false);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.fromBCP47((String)"pl-PL"));
        TextFragment frag = new TextFragment("&prod-actwksp-long; XRT rendering preferences include ");
        frag.append(TextFragment.TagType.PLACEHOLDER, "ph1", "{1}");
        frag.append("AWC_");
        frag.append(TextFragment.TagType.PLACEHOLDER, "ph2", "{2}");
        frag.append(" as a prefix to the preference name, allowing for the assignment of style sheets that are unique to &prod-actwksp-long;.");
        conn.query(frag);
        Assert.assertTrue((boolean)conn.hasNext());
        while (conn.hasNext()) {
            QueryResult qr = conn.next();
            this.logQueryResult(qr);
            Assert.assertTrue((boolean)qr.fromMT());
            Assert.assertTrue((boolean)qr.target.hasCode());
            Assert.assertFalse((boolean)qr.source.toText().equals(qr.target.toText()));
        }
        conn.close();
    }

    @Test
    public void testWithCodesEnclosingSeveralWords() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters params = conn.getParameters();
        params.setAuthKey(this.DEEPLAPIKEY);
        params.setPlainText(false);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.FRENCH);
        TextFragment frag = new TextFragment("This is ");
        frag.append(TextFragment.TagType.OPENING, "bold", "<B>");
        frag.append("quite a bold text");
        frag.append(TextFragment.TagType.CLOSING, "bold", "</B>");
        frag.append("  with ");
        frag.append(TextFragment.TagType.PLACEHOLDER, "lb", "<BR/>");
        frag.append(" and an ampersand &");
        conn.query(frag);
        Assert.assertTrue((boolean)conn.hasNext());
        while (conn.hasNext()) {
            QueryResult qr = conn.next();
            this.logQueryResult(qr);
            Assert.assertTrue((boolean)qr.fromMT());
            Assert.assertTrue((boolean)qr.target.hasCode());
        }
        conn.close();
    }

    @Test
    public void testNegativeCodeIDs() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters params = conn.getParameters();
        params.setAuthKey(this.DEEPLAPIKEY);
        params.setPlainText(false);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.FRENCH);
        TextFragment frag = new TextFragment("This is ");
        frag.append(TextFragment.TagType.OPENING, "bold", "<B>", -123);
        frag.append("quite a bold text");
        frag.append(TextFragment.TagType.CLOSING, "bold", "</B>", -123);
        conn.query(frag);
        Assert.assertTrue((boolean)conn.hasNext());
        while (conn.hasNext()) {
            QueryResult qr = conn.next();
            this.logger.info("src: {}", (Object)GenericContent.fromFragmentToLetterCoded((TextFragment)qr.source, (boolean)true));
            this.logger.info("trg: {}", (Object)GenericContent.fromFragmentToLetterCoded((TextFragment)qr.target, (boolean)true));
            Assert.assertTrue((boolean)qr.fromMT());
            Assert.assertTrue((boolean)qr.target.hasCode());
            Assert.assertEquals((long)-123L, (long)qr.target.getCode(0).getId());
        }
        conn.close();
    }

    @Test
    public void testRemoveDuplicateCodes() {
        String dupeCodeString = "<g-1>C'est un</g-1> <e5/><e5/>texte <b123/>assez <b123/>audacieux avec <x2/> et un <g-1>esperluet</g-1> & et un <g2>chien</g2> et un <g2>pomme</g2>.";
        String fixedString = "<g-1>C'est un</g-1> <e5/>texte <b123/>assez audacieux avec <x2/> et un esperluet & et un <g2>chien</g2> et un pomme.";
        try (DeepLv1Connector conn = new DeepLv1Connector();){
            Assert.assertEquals((Object)conn.removeDupeCodes(dupeCodeString), (Object)fixedString);
        }
    }

    @Test
    public void testBatchQueryGroupSizeLimits() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters deeplParams = conn.getParameters();
        deeplParams.setAuthKey(this.DEEPLAPIKEY);
        deeplParams.setPlainText(false);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.SPANISH);
        ArrayList<TextFragment> frags = new ArrayList<TextFragment>();
        for (int i = 1; i < 52; ++i) {
            frags.add(new TextFragment("This is number " + i + "."));
        }
        List queryResults = conn.batchQuery(frags);
        Assert.assertTrue((queryResults.size() == 51 ? 1 : 0) != 0);
        String str = ((QueryResult)((List)queryResults.get((int)50)).get((int)0)).source.toText();
        Assert.assertEquals((Object)str, (Object)"This is number 51.");
        str = ((QueryResult)((List)queryResults.get((int)50)).get((int)0)).target.toText();
        Assert.assertEquals((Object)str, (Object)"Este es el n\u00famero 51.");
        conn.close();
    }

    @Test
    public void testBatchQueryMaxRequestSize() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters deeplParams = conn.getParameters();
        deeplParams.setAuthKey(this.DEEPLAPIKEY);
        deeplParams.setPlainText(false);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.SPANISH);
        conn.setMaxRequestSize(200);
        ArrayList<TextFragment> frags = new ArrayList<TextFragment>();
        for (int i = 1; i < 30; ++i) {
            frags.add(new TextFragment("This is number " + i + "."));
        }
        List queryResults = conn.batchQuery(frags);
        int allResultsSize = queryResults.size();
        Assert.assertTrue((allResultsSize == 29 ? 1 : 0) != 0);
        List fragmentGroups = conn.getFragmentGroups();
        int fragGroupSize = fragmentGroups.size();
        Assert.assertTrue((fragGroupSize == 3 ? 1 : 0) != 0);
        conn.close();
    }

    @Test
    public void splitSentencesTest() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters params = conn.getParameters();
        params.setAuthKey(this.DEEPLAPIKEY);
        params.setSplitSentences(true);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.FRENCH);
        conn.query("First sentence. Then the second one. Then the third sentence.");
        Assert.assertTrue((boolean)conn.hasNext());
        QueryResult qr = conn.next();
        this.logQueryResult(qr);
        String tr1 = qr.target.toText();
        params.setSplitSentences(false);
        conn.query("First sentence. Then the second one. Then the third sentence.");
        Assert.assertTrue((boolean)conn.hasNext());
        qr = conn.next();
        this.logQueryResult(qr);
        String tr2 = qr.target.toText();
        Assert.assertFalse((boolean)tr1.equals(tr2));
        conn.close();
    }

    @Test
    public void preserveFormattingTest() {
        if (this.deeplKeyMissing()) {
            return;
        }
        DeepLv1Connector conn = new DeepLv1Connector();
        DeepLv1ConnectorParameters params = conn.getParameters();
        params.setAuthKey(this.DEEPLAPIKEY);
        params.setPreserveFormatting(true);
        conn.setLanguages(LocaleId.ENGLISH, LocaleId.FRENCH);
        conn.query("IMPORTANT first word, then some text...  ");
        Assert.assertTrue((boolean)conn.hasNext());
        QueryResult qr = conn.next();
        this.logQueryResult(qr);
        String tr1 = qr.target.toText();
        params.setPreserveFormatting(false);
        conn.query("IMPORTANT first word, then some text...  ");
        Assert.assertTrue((boolean)conn.hasNext());
        qr = conn.next();
        this.logQueryResult(qr);
        String tr2 = qr.target.toText();
        Assert.assertFalse((boolean)tr1.equals(tr2));
        conn.close();
    }

    boolean deeplKeyMissing() {
        if (this.DEEPLAPIKEY == null) {
            this.logger.warn("Test not run: you need a DeepL API key for it");
            return true;
        }
        return false;
    }

    void logQueryResult(QueryResult qr) {
        this.logger.info("src: {}", (Object)qr.source.toText());
        this.logger.info("trg: {}", (Object)qr.target.toText());
    }
}

