/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nervalreports.core;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import net.sf.nervalreports.core.ReportColor;
import net.sf.nervalreports.core.ReportColors;
import net.sf.nervalreports.core.ReportFontSize;
import net.sf.nervalreports.core.ReportGenerationException;
import net.sf.nervalreports.core.ReportGroupType;
import net.sf.nervalreports.core.ReportTextAlignment;
import net.sf.nervalreports.core.charsets.ReportCharset;
import net.sf.nervalreports.core.paper.ReportPaperFormat;
import net.sf.nervalreports.core.paper.formats.A4;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ReportGenerator {
    protected static final float PIXELS_TO_UNITS_FACTOR = 0.812f;
    protected final float UNITS_TO_PIXELS = 1.2315271f;
    private static final int BUFFER_INITIAL_SIZE = 4096;
    private StringBuilder stringBuilder;
    private ReportColor oddRowColor = ReportColors.DEFAULT_ODD_ROW_COLOR;
    private ReportColor evenRowColor = ReportColors.DEFAULT_EVEN_ROW_COLOR;
    private ReportColor rowColor = null;
    private ReportColor headerBackgroundColor = ReportColors.DEFAULT_HEADER_BACKGROUND_COLOR;
    private ReportColor borderColor = ReportColors.DEFAULT_TEXT_COLOR;
    private Float borderWidth = null;
    private ReportColor textColor = ReportColors.DEFAULT_TEXT_COLOR;
    private ReportPaperFormat paperFormat = A4.getSingleton();
    private ReportCharset charset;
    private int[] margins = new int[]{12, 12, 12, 12};
    private boolean bold;
    private boolean italic;
    private ReportFontSize fontSize = ReportFontSize.NORMAL;
    private ReportTextAlignment textAlignment = ReportTextAlignment.LEFT;
    private boolean documentBeginned;
    private boolean documentEnded;
    private boolean documentHasHead;
    private boolean documentHasBody;
    private Stack<ReportBlockToken> documentStack = new Stack();
    private Stack<ReportGroupType> lastGroupTypes = new Stack();
    private HashSet<String> colorNames = new HashSet();
    private HashSet<String> imageNames = new HashSet();

    public abstract String getFileExtension();

    public abstract boolean supportImages();

    public abstract boolean supportImagesOfJarFilesOrURLs();

    public abstract boolean isHeaderAndFooterDeclarationAtDocumentHead();

    protected abstract void doBeginDocument() throws Exception;

    protected abstract void doEndDocument() throws Exception;

    protected abstract void doBeginDocumentHead() throws Exception;

    protected abstract void doAddColor(ReportColor var1) throws Exception;

    protected abstract void doHintFont(boolean var1) throws Exception;

    protected abstract void doHintLanguage(String var1) throws Exception;

    protected abstract void doDefineMargins(int var1, int var2, int var3, int var4) throws Exception;

    protected abstract void doEndDocumentHead() throws Exception;

    protected abstract void doBeginDocumentBody() throws Exception;

    protected abstract void doEndDocumentBody() throws Exception;

    protected abstract void doBeginTable(int var1, int[] var2) throws Exception;

    protected abstract void doEndTable() throws Exception;

    protected abstract void doBeginTableHeaderRow() throws Exception;

    protected abstract void doAddTableHeaderCell(String var1, int var2) throws Exception;

    protected abstract void doEndTableHeaderRow() throws Exception;

    protected abstract void doBeginTableRow() throws Exception;

    protected abstract void doBeginTableCell(int var1, int var2) throws Exception;

    protected abstract void doEndTableCell() throws Exception;

    protected abstract void doEndTableRow() throws Exception;

    protected abstract void doBeginGroup(ReportGroupType var1, String var2) throws Exception;

    protected abstract void doEndGroup(ReportGroupType var1) throws Exception;

    protected abstract void doAddImage(byte[] var1, String var2, int var3) throws Exception;

    protected abstract void doAddLinkedImage(String var1, int var2) throws Exception;

    protected abstract void doCreateLineSpaces(int var1) throws Exception;

    protected abstract void doLineBreak() throws Exception;

    protected abstract void doAddText(String var1) throws Exception;

    protected abstract void doAddSeparatorLine() throws Exception;

    protected abstract void doAddCurrentPageNumber() throws Exception;

    protected abstract void doAddTotalPagesCount() throws Exception;

    protected abstract void doBeginPageHeaderLeft() throws Exception;

    protected abstract void doEndPageHeaderLeft() throws Exception;

    protected abstract void doBeginPageHeaderCenter() throws Exception;

    protected abstract void doEndPageHeaderCenter() throws Exception;

    protected abstract void doBeginPageHeaderRight() throws Exception;

    protected abstract void doEndPageHeaderRight() throws Exception;

    protected abstract void doBeginPageFooterLeft() throws Exception;

    protected abstract void doEndPageFooterLeft() throws Exception;

    protected abstract void doBeginPageFooterCenter() throws Exception;

    protected abstract void doEndPageFooterCenter() throws Exception;

    protected abstract void doBeginPageFooterRight() throws Exception;

    protected abstract void doEndPageFooterRight() throws Exception;

    public void saveToFile(String filename) throws ReportGenerationException {
        if (this.stringBuilder == null) {
            throw new IllegalStateException("The document declaration didn't start or it was freed.");
        }
        if (this.documentStack.size() > 0) {
            throw new IllegalStateException("The document declaration didn't finished.");
        }
        File file = new File(filename);
        try {
            if (this.charset == null) {
                FileUtils.writeStringToFile((File)file, (String)this.getStringBuilder().toString());
            } else {
                FileUtils.writeStringToFile((File)file, (String)this.getStringBuilder().toString(), (Charset)this.charset.getCharset());
            }
        }
        catch (IOException e) {
            throw new ReportGenerationException(e);
        }
    }

    public byte[] toByteArray() throws ReportGenerationException {
        if (this.stringBuilder == null) {
            throw new IllegalStateException("The document declaration didn't start or it was freed.");
        }
        if (this.documentStack.size() > 0) {
            throw new IllegalStateException("The document declaration didn't finished.");
        }
        return this.getStringBuilder().toString().getBytes();
    }

    public String toString() {
        if (this.stringBuilder == null) {
            throw new IllegalStateException("The document declaration didn't start or it was freed.");
        }
        if (this.documentStack.size() > 0) {
            throw new IllegalStateException("The document declaration didn't finished.");
        }
        return this.stringBuilder.toString();
    }

    public void release() {
        this.stringBuilder = null;
        this.clear();
    }

    private void clear() {
        this.documentBeginned = false;
        this.documentEnded = false;
        this.documentHasHead = false;
        this.documentHasBody = false;
        this.documentStack.clear();
        this.lastGroupTypes.clear();
        this.colorNames.clear();
        this.imageNames.clear();
        this.bold = false;
        this.italic = false;
        this.textColor = ReportColors.DEFAULT_TEXT_COLOR;
        this.fontSize = ReportFontSize.NORMAL;
        this.textAlignment = ReportTextAlignment.LEFT;
        this.oddRowColor = ReportColors.DEFAULT_ODD_ROW_COLOR;
        this.evenRowColor = ReportColors.DEFAULT_EVEN_ROW_COLOR;
        this.headerBackgroundColor = ReportColors.DEFAULT_HEADER_BACKGROUND_COLOR;
        this.rowColor = null;
        this.borderColor = null;
        this.borderWidth = null;
        int[] defaultMargin = new int[]{12, 12, 12, 12};
        this.margins = defaultMargin;
        this.charset = null;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public ReportFontSize getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(ReportFontSize fontSize) {
        this.fontSize = fontSize;
    }

    public ReportTextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(ReportTextAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public ReportColor getOddRowColor() {
        return this.oddRowColor;
    }

    public void setOddRowColor(ReportColor oddRowColor) {
        if (oddRowColor == null) {
            throw new IllegalArgumentException("Color should not be null. Use ReportColors.WHITE instead.");
        }
        this.oddRowColor = oddRowColor;
    }

    public ReportColor getEvenRowColor() {
        return this.evenRowColor;
    }

    public void setEvenRowColor(ReportColor evenRowColor) {
        if (evenRowColor == null) {
            throw new IllegalArgumentException("Color should not be null. Use ReportColors.WHITE instead.");
        }
        this.evenRowColor = evenRowColor;
    }

    public ReportColor getRowColor() {
        return this.rowColor;
    }

    public void setRowColor(ReportColor rowColor) {
        this.rowColor = rowColor;
    }

    public ReportColor getHeaderBackgroundColor() {
        return this.headerBackgroundColor;
    }

    public void setHeaderBackgroundColor(ReportColor headerBackgroundColor) {
        if (headerBackgroundColor == null) {
            throw new IllegalArgumentException("Color should not be null. Use ReportColors.WHITE instead.");
        }
        this.headerBackgroundColor = headerBackgroundColor;
    }

    public ReportColor getBorderColor() {
        return this.borderColor;
    }

    public Float getBorderWidth() {
        return this.borderWidth;
    }

    public ReportColor getTextColor() {
        return this.textColor;
    }

    public void setTextColor(ReportColor color) {
        if (color == null) {
            throw new IllegalArgumentException("Color should not be null. Use ReportColors.WHITE instead.");
        }
        this.textColor = color;
    }

    protected StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public void beginDocument() throws ReportGenerationException {
        if (this.documentBeginned) {
            throw new IllegalStateException("You can't begin a document for more than once.");
        }
        this.stringBuilder = new StringBuilder(4096);
        try {
            this.doBeginDocument();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.documentBeginned = true;
        this.documentStack.push(ReportBlockToken.DOCUMENT);
        this.colorNames.clear();
        for (ReportColor color : ReportColors.DEFINED_COLORS) {
            this.colorNames.add(color.getName());
        }
        this.imageNames.clear();
    }

    public void endDocument() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.DOCUMENT);
        try {
            this.doEndDocument();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.documentEnded = true;
    }

    public void beginDocumentHead() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        if (this.documentHasHead) {
            throw new IllegalStateException("It's only possible a head per document.");
        }
        try {
            this.doBeginDocumentHead();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.documentHasHead = true;
        this.documentStack.push(ReportBlockToken.DOCUMENT_HEAD);
    }

    public ReportColor addColor(int red, int green, int blue, String name) throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.DOCUMENT_HEAD);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("The color name should not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)name) || name.contains(" ")) {
            throw new IllegalArgumentException("The color name is mandatory and shouldn't contain spaces.");
        }
        if (this.colorNames.contains(name)) {
            throw new IllegalArgumentException("The color name should be unique per report.");
        }
        ReportColor color = new ReportColor(red, green, blue, name);
        try {
            this.doAddColor(color);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.colorNames.add(name);
        return color;
    }

    public void setPaper(ReportPaperFormat paperFormat) {
        if (paperFormat == null) {
            throw new IllegalArgumentException("Paper should not be null.");
        }
        this.checkStackState(false, ReportBlockToken.DOCUMENT_HEAD);
        this.paperFormat = paperFormat;
    }

    public ReportPaperFormat getPaperFormat() {
        return this.paperFormat;
    }

    public void setMargins(int left, int top, int right, int bottom) throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.DOCUMENT);
        if (this.documentHasHead || this.documentHasBody) {
            throw new IllegalArgumentException("Margin definition must be set after document begin, but before document head or body.");
        }
        try {
            this.margins[0] = left;
            this.margins[1] = top;
            this.margins[2] = right;
            this.margins[3] = bottom;
            this.doDefineMargins(left, top, right, bottom);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public int[] getMargins() {
        return this.margins;
    }

    public void hintLanguage(String language) throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.DOCUMENT_HEAD);
        try {
            this.doHintLanguage(language);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void setReportCharset(ReportCharset charset) throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.DOCUMENT_HEAD);
        this.charset = charset;
    }

    public ReportCharset getReportCharset() {
        return this.charset;
    }

    public void hintSerifFont() throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.DOCUMENT_HEAD);
        try {
            this.doHintFont(true);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void hintNonSerifFont() throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.DOCUMENT_HEAD);
        try {
            this.doHintFont(false);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endDocumentHead() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.DOCUMENT_HEAD);
        try {
            this.doEndDocumentHead();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void beginDocumentBody() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        if (this.documentHasBody) {
            throw new IllegalStateException("A report can't have multiple bodies.");
        }
        try {
            this.doBeginDocumentBody();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.documentHasBody = true;
        this.documentStack.push(ReportBlockToken.DOCUMENT_BODY);
    }

    public void endDocumentBody() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.DOCUMENT_BODY);
        try {
            this.doEndDocumentBody();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void setTableBorderStyle(Float borderWidth, ReportColor borderColor) {
        this.checkDocumentNotFinished();
        this.borderWidth = borderWidth;
        this.borderColor = borderColor;
    }

    public void beginTable(int totalColumns, int ... eachColumnWidth) throws ReportGenerationException {
        if (eachColumnWidth != null && eachColumnWidth.length != 0 && totalColumns != eachColumnWidth.length) {
            throw new IllegalArgumentException("One must define all column widths or none at all.");
        }
        this.checkDocumentNotFinished();
        try {
            if (eachColumnWidth != null && eachColumnWidth.length > 0) {
                this.doBeginTable(totalColumns, eachColumnWidth);
            } else {
                this.doBeginTable(totalColumns, null);
            }
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.documentStack.push(ReportBlockToken.TABLE);
    }

    public void beginTableWithFixedDefinedWidth(int totalColumns, int fixedWidth) throws ReportGenerationException {
        int[] colWidths = new int[totalColumns];
        for (int i = 0; i < totalColumns; ++i) {
            colWidths[i] = fixedWidth;
        }
        this.beginTable(totalColumns, colWidths);
    }

    public void endTable() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.TABLE);
        try {
            this.doEndTable();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void addTableHeaderRow(List<String> header) throws ReportGenerationException {
        if (header == null || header.size() <= 0) {
            throw new IllegalArgumentException("The list with column titles should not be empty.");
        }
        this.beginTableHeaderRow();
        for (String column : header) {
            this.addTableHeaderCell(column);
        }
        this.endTableHeaderRow();
    }

    public void beginTableHeaderRow() throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.TABLE, ReportBlockToken.TABLE_HEADER);
        try {
            this.doBeginTableHeaderRow();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.documentStack.push(ReportBlockToken.TABLE_HEADER);
    }

    public void addTableHeaderCell(String columnName) throws ReportGenerationException {
        this.addTableHeaderCell(columnName, 1);
    }

    public void addTableHeaderCell(String columnName, int colspan) throws ReportGenerationException {
        if (StringUtils.isEmpty((CharSequence)columnName)) {
            throw new IllegalArgumentException("Column's name shouldn't empty.");
        }
        if (colspan <= 0) {
            throw new IllegalArgumentException("The cell can't occupy a space lesser then 1.");
        }
        this.checkStackState(false, ReportBlockToken.TABLE_HEADER);
        try {
            this.doAddTableHeaderCell(columnName, colspan);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endTableHeaderRow() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.TABLE_HEADER);
        try {
            this.doEndTableHeaderRow();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void addTableRow(List<String> cells) throws ReportGenerationException {
        if (cells == null || cells.size() <= 0) {
            throw new IllegalArgumentException("The row cells must be defined.");
        }
        this.beginTableRow();
        for (String column : cells) {
            this.addTableCell(column, 1, 1);
        }
        this.endTableRow();
    }

    public void beginTableRow() throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.TABLE);
        try {
            this.doBeginTableRow();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.documentStack.push(ReportBlockToken.TABLE_ROW);
    }

    public void beginTableCell() throws ReportGenerationException {
        this.beginTableCell(1, 1);
    }

    public void beginTableCell(int colspan, int rowspan) throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.TABLE_ROW);
        if (colspan <= 0 || rowspan <= 0) {
            throw new IllegalArgumentException("The cell can't occupy a space lesser then 1.");
        }
        try {
            this.doBeginTableCell(colspan, rowspan);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.documentStack.push(ReportBlockToken.TABLE_ELEMENT);
    }

    public void addTableCell(String element, int colspan, int rowspan) throws ReportGenerationException {
        this.beginTableCell(colspan, rowspan);
        this.addText(element);
        this.endTableCell();
    }

    public void addTableCell(String element) throws ReportGenerationException {
        this.addTableCell(element, 1, 1);
    }

    public void endTableCell() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.TABLE_ELEMENT);
        try {
            this.doEndTableCell();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endTableRow() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.TABLE_ROW);
        try {
            this.doEndTableRow();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void beginGroup(ReportGroupType type) throws ReportGenerationException {
        this.beginGroup(type, null);
    }

    public void beginGroup(ReportGroupType type, String name) throws ReportGenerationException {
        this.checkStackState(false, ReportBlockToken.DOCUMENT_BODY, ReportBlockToken.GROUP, ReportBlockToken.TABLE_ELEMENT);
        if (type == null) {
            throw new IllegalArgumentException("The report group must be defined.");
        }
        this.lastGroupTypes.push(type);
        this.documentStack.push(ReportBlockToken.GROUP);
        try {
            this.doBeginGroup(type, name);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endGroup() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.GROUP);
        ReportGroupType type = this.lastGroupTypes.pop();
        try {
            this.doEndGroup(type);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void addCurrentPageNumber() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        try {
            this.doAddCurrentPageNumber();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    protected boolean isInsideHeaderOrFooter() {
        for (ReportBlockToken token : this.documentStack) {
            if (!ReportBlockToken.PAGE_FOOTER_LEFT.equals((Object)token) && !ReportBlockToken.PAGE_FOOTER_CENTER.equals((Object)token) && !ReportBlockToken.PAGE_FOOTER_RIGHT.equals((Object)token) && !ReportBlockToken.PAGE_HEADER_LEFT.equals((Object)token) && !ReportBlockToken.PAGE_HEADER_CENTER.equals((Object)token) && !ReportBlockToken.PAGE_HEADER_RIGHT.equals((Object)token)) continue;
            return true;
        }
        return false;
    }

    public void addTotalPagesCount() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        if (!this.isInsideHeaderOrFooter()) {
            throw new IllegalStateException("Total pages count is only valid inside header or footer.");
        }
        try {
            this.doAddTotalPagesCount();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void beginPageHeaderLeft() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        this.documentStack.push(ReportBlockToken.PAGE_HEADER_LEFT);
        try {
            this.doBeginPageHeaderLeft();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endPageHeaderLeft() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.PAGE_HEADER_LEFT);
        try {
            this.doEndPageHeaderLeft();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void beginPageHeaderCenter() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        this.documentStack.push(ReportBlockToken.PAGE_HEADER_CENTER);
        try {
            this.doBeginPageHeaderCenter();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endPageHeaderCenter() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.PAGE_HEADER_CENTER);
        try {
            this.doEndPageHeaderCenter();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void beginPageHeaderRight() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        this.documentStack.push(ReportBlockToken.PAGE_HEADER_RIGHT);
        try {
            this.doBeginPageHeaderRight();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endPageHeaderRight() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.PAGE_HEADER_RIGHT);
        try {
            this.doEndPageHeaderRight();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void beginPageFooterLeft() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        this.documentStack.push(ReportBlockToken.PAGE_FOOTER_LEFT);
        try {
            this.doBeginPageFooterLeft();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endPageFooterLeft() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.PAGE_FOOTER_LEFT);
        try {
            this.doEndPageFooterLeft();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void beginPageFooterCenter() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        this.documentStack.push(ReportBlockToken.PAGE_FOOTER_CENTER);
        try {
            this.doBeginPageFooterCenter();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endPageFooterCenter() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.PAGE_FOOTER_CENTER);
        try {
            this.doEndPageFooterCenter();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void beginPageFooterRight() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        this.documentStack.push(ReportBlockToken.PAGE_FOOTER_RIGHT);
        try {
            this.doBeginPageFooterRight();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void endPageFooterRight() throws ReportGenerationException {
        this.checkStackState(true, ReportBlockToken.PAGE_FOOTER_RIGHT);
        try {
            this.doEndPageFooterRight();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void addImage(byte[] img, String imgName, int width) throws ReportGenerationException {
        this.checkDocumentNotFinished();
        if (img == null || img.length == 0) {
            throw new IllegalArgumentException("The image should not be empty.");
        }
        if (StringUtils.isEmpty((CharSequence)imgName) || imgName.contains(" ")) {
            throw new IllegalArgumentException("The image name is mandatory and shouldn't contain spaces.");
        }
        if (this.imageNames.contains(imgName)) {
            throw new IllegalArgumentException("The image name should be unique per report.");
        }
        try {
            this.doAddImage(img, imgName, width);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
        this.imageNames.add(imgName);
    }

    private boolean isInnerJarFile(String link) {
        return link.startsWith("jar:");
    }

    public void addLinkedImage(String imgLink, int width) throws ReportGenerationException {
        this.checkDocumentNotFinished();
        if (StringUtils.isEmpty((CharSequence)imgLink)) {
            throw new IllegalArgumentException("Image link should not be empty.");
        }
        if (this.isInnerJarFile(imgLink) && !this.supportImagesOfJarFilesOrURLs()) {
            throw new IllegalArgumentException(String.format("This generator doesn't support images inner a jar. %s", "You should externally save it and use the link, or add them with the data already read with addImage function."));
        }
        try {
            this.doAddLinkedImage(imgLink, width);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void addLineSpaces(int n) throws ReportGenerationException {
        this.checkDocumentNotFinished();
        if (n <= 0) {
            throw new IllegalArgumentException("The number of blank lines must be greater than 0.");
        }
        try {
            this.doCreateLineSpaces(n);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void addLineBreak() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        try {
            this.doLineBreak();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void addTextWithNullSupport(String text) throws ReportGenerationException {
        this.checkDocumentNotFinished();
        if (StringUtils.isBlank((CharSequence)text)) {
            this.addText("-");
        } else {
            this.addText(text);
        }
    }

    public void addText(String text) throws ReportGenerationException {
        this.checkDocumentNotFinished();
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("Can't add an empty text.");
        }
        try {
            this.doAddText(text);
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    public void addTextLine(String line) throws ReportGenerationException {
        this.addText(line);
        this.addLineSpaces(1);
    }

    public void addSeparatorLine() throws ReportGenerationException {
        this.checkDocumentNotFinished();
        try {
            this.doAddSeparatorLine();
        }
        catch (Exception e) {
            throw new ReportGenerationException(e);
        }
    }

    protected void checkDocumentNotFinished() {
        if (!this.documentBeginned || this.documentEnded) {
            throw new IllegalStateException("The document wasn't inited or is already finished.");
        }
    }

    protected void checkNotOpenedFooterOrHeader() {
        if (this.documentStack.size() == 0) {
            return;
        }
        for (ReportBlockToken token : this.documentStack) {
            if (!ReportBlockToken.PAGE_FOOTER_CENTER.equals((Object)token) && !ReportBlockToken.PAGE_FOOTER_LEFT.equals((Object)token) && !ReportBlockToken.PAGE_FOOTER_RIGHT.equals((Object)token) && !ReportBlockToken.PAGE_HEADER_CENTER.equals((Object)token) && !ReportBlockToken.PAGE_HEADER_LEFT.equals((Object)token) && !ReportBlockToken.PAGE_FOOTER_RIGHT.equals((Object)token)) continue;
            throw new IllegalStateException(String.format("Not valid inner a '%s'.", token.toString()));
        }
    }

    protected void checkStackState(boolean pop, ReportBlockToken ... expected) {
        ReportBlockToken current = pop ? this.documentStack.pop() : this.documentStack.peek();
        if (current == null) {
            throw new IllegalStateException("Stack's top is null.");
        }
        boolean found = false;
        for (ReportBlockToken possibleExpected : expected) {
            if (!current.equals((Object)possibleExpected)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException(String.format("Stack's top '%s' isn't expected.", current.toString()));
        }
    }

    private static enum ReportBlockToken {
        DOCUMENT,
        DOCUMENT_HEAD,
        DOCUMENT_BODY,
        TABLE,
        TABLE_HEADER,
        TABLE_ROW,
        TABLE_ELEMENT,
        GROUP,
        PAGE_HEADER_LEFT,
        PAGE_HEADER_CENTER,
        PAGE_HEADER_RIGHT,
        PAGE_FOOTER_LEFT,
        PAGE_FOOTER_CENTER,
        PAGE_FOOTER_RIGHT;

    }
}

