/** This file is part of nervalreports.
 *
 * nervalreports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nervalreports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nervalreports.  If not, see <http://www.gnu.org/licenses/>. */
package net.sf.nervalreports.core.paper.formats;

import net.sf.nervalreports.core.paper.ReportPaperFormat;

/** Format definition for A5 paper.
 * @author farrer */
public class A5 extends ReportPaperFormat {
	
	private static final A5 singleton = new A5();
	
	private final String TEX_NAME = "a5paper";
	private final String HTML_NAME = "A5";
	
	/** @return the singleton instance of this class. */
	public static A5 getSingleton() {
		return singleton;
	}
	
	/** Private constructor, to avoid multiple instances. */
	private A5() {
	}

	/** {@inheritDoc} */
	@Override
	protected int getWidthInMillimeters() {
		return 148;
	}

	/** {@inheritDoc} */
	@Override
	protected int getHeightInMillimeters() {
		return 210;
	}

	/** {@inheritDoc} */
	@Override
	public String getTeXName() {
		return TEX_NAME;
	}

	/** {@inheritDoc} */
	@Override
	public String getHtmlName() {
		return HTML_NAME;
	}

}
