/** This file is part of nervalreports.
 *
 * nervalreports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nervalreports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nervalreports.  If not, see <http://www.gnu.org/licenses/>. */
package net.sf.nervalreports.core.charsets;

import java.nio.charset.Charset;

/** UTF8 character set, with LaTeX T1 output font support.
 * @author farrer */
public class UTF8 extends ReportCharset {
	
	private static final String CHARSET_STRING = "UTF8";
	private static final String LATEX_FONT_ENC = "T1";
	private static final String LATEX_INPUT_ENC = "utf8";

	/** Default constructor */
	public UTF8() {
		super(Charset.forName(CHARSET_STRING));
	}
	
	/** {@inheritDoc} */
	@Override
	public String getLaTeXFontEnc() throws UnsupportedOperationException {
		return LATEX_FONT_ENC;
	}

	/** {@inheritDoc} */
	@Override
	public String getLaTeXInputEnc() throws UnsupportedOperationException {
		return LATEX_INPUT_ENC;
	}

}
