/** This file is part of nervalreports.
 *
 * nervalreports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nervalreports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nervalreports.  If not, see <http://www.gnu.org/licenses/>. */
package net.sf.nervalreports.core.charsets;

import java.nio.charset.Charset;

/** The basic class for charsets definitions. It's a java {@link Charset} with respective charset enconding name used on LaTeX input text and font.
 * If you are not using LaTeX generator, just setting the Charset will be sufficient.
 * @author farrer */
public abstract class ReportCharset {

	/** Java Charset relative to this report charset. */
	private final Charset charset;
	
	/** Internal constructor.
	 * @param charset to use. */
	public ReportCharset(Charset charset) {
		this.charset = charset;
	}
	
	/** @return The type of font used on <code>\\usepackage[]{fontenc}</code>.
	 * @throws UnsupportedOperationException if without LaTeX support. */
	public abstract String getLaTeXFontEnc() throws UnsupportedOperationException;
	
	/** @return The type of enconding used on <code>\\usepackage[]{inputenc}</code>.
	 * @throws UnsupportedOperationException if without LaTeX support. */
	public abstract String getLaTeXInputEnc() throws UnsupportedOperationException;
	
	/** @return {@link #charset}. */
	public Charset getCharset() {
		return charset;
	}
	
}
