/** This file is part of nervalreports.
 *
 * nervalreports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nervalreports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nervalreports.  If not, see <http://www.gnu.org/licenses/>. */
package net.sf.nervalreports.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/** A group of useful functions for {@link TextualFileConverter}'s.
 * @author farrer */
public class TextualFileConverterUtils {
	
	/** Get process' output as an UTF-8 encoded {@link String}.
	 * @param process process from where we'll get its output.
	 * @param stderr <code>true</code> for stderr output, <code>false</code> for stdout.
	 * @return String with the process output, encoded in UTF-8.
	 * @throws IOException in case of error. */
	public static String getProcessOutputAsString(Process process, boolean stderr) throws IOException {

		InputStream inputStream = (stderr) ? process.getErrorStream() : process.getInputStream(); 

		try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));) {
			String line = null;
			StringBuilder stringBuilder = new StringBuilder();
			while ((line = br.readLine()) != null) {
				stringBuilder.append(line);
				stringBuilder.append("\n");
			}
			return stringBuilder.toString();
		} 
	}

}
