/** This file is part of nervalreports.
 *
 * nervalreports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nervalreports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nervalreports.  If not, see <http://www.gnu.org/licenses/>. */
package net.sf.nervalreports.core;

/** Definition of possible types of element groups in a report.
 * @author farrer */
public enum ReportGroupType {
	/** Block group, isolated of other report elements outside it at the same context. */
	BLOCK,
	/** Inlined group, not isolated. */
	INLINE,
	/** Paragraph group, usually for block of texts with an special align. */
	PARAGRAPH,
	/** An special group used to contain a single image in the document. */
	IMAGE_CONTAINER
}
