/** This file is part of nervalreports.
 *
 * nervalreports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nervalreports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nervalreports.  If not, see <http://www.gnu.org/licenses/>. */
package net.sf.nervalreports.core;

/** Exception for some specific {@link ReportGenerator}'s implementations failures.
 * @author farrer */
public class ReportGenerationException extends Exception {

	private static final long serialVersionUID = 3373958794321719940L;
	
	/** Construct with another exception.
    * @param e exception to encapsulate as a ReportGenerationException. */
	public ReportGenerationException(Exception e) {
		super(e.getMessage(), e.getCause());
		setStackTrace(e.getStackTrace());
	}

	/** Default Constructor.
    * @see Exception#Exception() */
	public ReportGenerationException() {
		super();
	}

	/** Constructor with message.
    * @param message defining the exception. 
    * @see Exception#Exception(String) */
	public ReportGenerationException(String message) {
		super(message);
	}

	/** Constructor with message and Throwable.
    * @param message defining the exception.
    * @param cause of the exception. 
    * @see Exception#Exception(String, Throwable) */
	public ReportGenerationException(String message, Throwable cause) {
		super(message, cause);
	}

	/** Constructor with a Throwable.
    * @param cause of the exception. 
    * @see Exception#Exception(Throwable) */
	public ReportGenerationException(Throwable cause) {
		super(cause);
	}


}
