/** This file is part of nervalreports.
 *
 * nervalreports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nervalreports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nervalreports.  If not, see <http://www.gnu.org/licenses/>. */
package net.sf.nervalreports.core;

/** Enumeration of supported font sizes. There's no guarantee that a value in one generator will be of exactly same size
 * on another generator. The only certain thing between them is the respected order of 'bigness' (tiny is smaller than small which is
 * smaller than large and so on).   
 * @author farrer */
public enum ReportFontSize {
	TINY,
	EXTRA_SMALL,
	SMALL,
	NORMAL,
	LARGE,
	EXTRA_LARGE,
	HUGE
}
