/** This file is part of nervalreports.
 *
 * nervalreports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nervalreports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nervalreports.  If not, see <http://www.gnu.org/licenses/>. */
package net.sf.nervalreports.core;

/** Useful predefined colors.
 * @author farrer */
public class ReportColors {
	
	public static final ReportColor BLACK = new ReportColor(0, 0, 0, "nervalBlack");
	
	public static final ReportColor BLUE = new ReportColor(0, 0, 255, "nervalBlue");
	
	public static final ReportColor CYAN = new ReportColor(0, 255, 255, "nervalCyan");
	
	public static final ReportColor GOLD = new ReportColor(255, 215, 0, "nervalGold");
	
	public static final ReportColor GREEN = new ReportColor(0, 128, 0, "nervalGreen");
	
	public static final ReportColor MAGENTA = new ReportColor(255, 0, 255, "nervalMagenta"); 
	
	public static final ReportColor ORANGE = new ReportColor(255, 165, 0, "nervalOrange");
	
	public static final ReportColor RED = new ReportColor(255, 0, 0, "nervalRed");
	
	public static final ReportColor WHITE = new ReportColor(255, 255, 255, "nervalWhite");
	
	public static final ReportColor YELLOW = new ReportColor(255, 255, 0, "nervalYellow");
	
	public static final ReportColor DEFAULT_ODD_ROW_COLOR = WHITE;
	
	public static final ReportColor DEFAULT_EVEN_ROW_COLOR = new ReportColor(242, 242, 242, "nervalEvenRow");
	
	public static final ReportColor DEFAULT_TEXT_COLOR = BLACK;
	
	public static final ReportColor DEFAULT_HEADER_BACKGROUND_COLOR = new ReportColor(44, 131, 171, "nervalHeaderBg");

	public static final int TOTAL_COLORS = 12;
	
	/** Array with all distinct colors defined in {@link ReportColors}.  */
	public static final ReportColor[] DEFINED_COLORS = new ReportColor[TOTAL_COLORS];
	
	static {
		DEFINED_COLORS[0] = BLACK;
		DEFINED_COLORS[1] = BLUE;
		DEFINED_COLORS[2] = CYAN;
		DEFINED_COLORS[3] = GOLD;
		DEFINED_COLORS[4] = GREEN;
		DEFINED_COLORS[5] = MAGENTA;
		DEFINED_COLORS[6] = ORANGE;
		DEFINED_COLORS[7] = RED;
		DEFINED_COLORS[8] = WHITE;
		DEFINED_COLORS[9] = YELLOW;
		DEFINED_COLORS[10] = DEFAULT_EVEN_ROW_COLOR;
		DEFINED_COLORS[11] = DEFAULT_HEADER_BACKGROUND_COLOR;
	}
	
}
