/** This file is part of nervalreports.
 *
 * nervalreports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nervalreports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nervalreports.  If not, see <http://www.gnu.org/licenses/>. */
package net.sf.nervalreports.core;

/** A color representation to be used on reports.
 * @author farrer */
public class ReportColor {
	
	/** Red component of the color. */
	private final int red;
	/** Green component of the color. */
	private final int green;
	/** Blue component of the color. */
	private final int blue;
	/** Colors name. */
	private final String name;

	/** Default constructor for a color in RGB mode.
	 * @param red red component of the color [0, 255].
	 * @param green green component of the color [0, 255].
	 * @param blue blue component of the color [0, 255].
	 * @param name color's name. */
	/* default */ ReportColor(int red, int green, int blue, String name) {
		if ((red < 0) || (red > 255) || (green < 0) || (green > 255) || (blue < 0) || (blue > 255)) {
			throw new IllegalArgumentException("Color component should be in [0, 255] range.");
		}
		this.red = red;
		this.green = green;
		this.blue = blue;
		this.name = name;
	}

	/** @return {@link #red}. */
	public int getRed() {
		return red;
	}

	/** @return {@link #green}. */
	public int getGreen() {
		return green;
	}

	/** @return {@link #blue}. */
	public int getBlue() {
		return blue;
	}

	/** @return {@link #name}. */
	public String getName() {
		return name;
	}

}
