/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.bluetooth;

import java.io.DataOutputStream;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import net.sf.microlog.midp.bluetooth.BluetoothConnectionHandler;
import net.sf.microlog.midp.bluetooth.BluetoothRemoteDevice;
import net.sf.microlog.midp.bluetooth.BluetoothServiceSearch;

class BluetoothConnectionHandlerImpl
implements BluetoothConnectionHandler {
    private String connectionString = null;
    private StreamConnection connection = null;
    private DataOutputStream dataOutputStream = null;
    private String bluetoothClientID = null;
    private BluetoothServiceSearch serviceSearch = BluetoothServiceSearch.newInstance();

    BluetoothConnectionHandlerImpl() {
    }

    public void findAndSetConnectionString(BluetoothRemoteDevice remoteDevice) {
        this.connectionString = this.serviceSearch.getLoggerServiceString(remoteDevice);
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public boolean openConnection() {
        boolean connectionOpen = false;
        if (this.connectionString == null && !this.serviceSearch.hasServiceError()) {
            this.connectionString = this.serviceSearch.getLoggerServiceString();
        }
        try {
            connectionOpen = this.openOutputStream();
        }
        catch (IOException e) {
            System.err.println("Failed to connect to the Bluetooth log server with connection string " + this.connectionString + ' ' + e);
        }
        return connectionOpen;
    }

    private boolean openOutputStream() throws IOException {
        boolean openedOutputStream = false;
        if (this.connectionString != null && !this.serviceSearch.hasServiceError()) {
            this.connection = (StreamConnection)Connector.open((String)this.connectionString);
            this.dataOutputStream = this.connection.openDataOutputStream();
            openedOutputStream = true;
        }
        return openedOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownLoggingService() throws IOException {
        if (this.dataOutputStream != null) {
            try {
                this.dataOutputStream.writeUTF("[STOP]");
            }
            catch (IOException io) {
                System.err.println("Failed to send [STOP] to the Bluetooth server, " + io);
            }
            finally {
                this.close();
            }
        }
    }

    public void close() throws IOException {
        if (this.dataOutputStream != null) {
            try {
                this.dataOutputStream.close();
            }
            catch (IOException e) {
                System.err.println("Failed to terminate the dataOutputStream in a controlled way." + e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                System.err.println("Failed to close the log " + e);
            }
        }
    }

    public void writeLogToStream(String formattedLogStatement) {
        if (this.dataOutputStream != null) {
            try {
                this.dataOutputStream.writeUTF(formattedLogStatement);
                this.dataOutputStream.flush();
            }
            catch (IOException io) {
                System.err.println("Unable to log to the output stream. " + io);
            }
        }
    }

    public String getBluetoothClientID(String clientID) {
        if (this.bluetoothClientID == null) {
            if (clientID == null || clientID.length() == 0) {
                this.bluetoothClientID = this.getBluetoothFriendlyName();
            }
            if (clientID != null || this.bluetoothClientID == null) {
                this.bluetoothClientID = clientID;
            }
        }
        return this.bluetoothClientID;
    }

    private String getBluetoothFriendlyName() {
        String bluetoothFriendlyName = "";
        try {
            bluetoothFriendlyName = LocalDevice.getLocalDevice().getFriendlyName();
        }
        catch (BluetoothStateException bse) {
            System.err.println("Unable to get the Bluetooth friendly name, " + (Object)((Object)bse));
        }
        return bluetoothFriendlyName;
    }
}

