/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.Logger;
import net.sf.microlog.core.LoggerRepository;
import net.sf.microlog.core.RepositoryNode;

class DefaultLoggerRepository
implements LoggerRepository {
    private static DefaultLoggerRepository loggerRepository = new DefaultLoggerRepository();
    private RepositoryNode rootNode;
    private Hashtable leafNodeHashtable = new Hashtable(43);

    private DefaultLoggerRepository() {
        Logger rootLogger = new Logger("");
        rootLogger.setLevel(Level.DEBUG);
        this.rootNode = new RepositoryNode("", rootLogger);
    }

    public static DefaultLoggerRepository getInstance() {
        return loggerRepository;
    }

    public Logger getRootLogger() {
        return this.rootNode.logger;
    }

    public synchronized Logger getLogger(String name) {
        RepositoryNode node = (RepositoryNode)this.leafNodeHashtable.get(name);
        Logger logger = null;
        if (node == null) {
            logger = new Logger(name);
            this.addLogger(logger);
        } else {
            logger = node.getLogger();
        }
        return logger;
    }

    synchronized void addLogger(Logger logger) {
        String loggerName = logger.getName();
        int beginIndex = 0;
        int endIndex = loggerName.indexOf(46);
        RepositoryNode currentNode = this.rootNode;
        while (endIndex != -1) {
            String pathComponent = loggerName.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            RepositoryNode child = currentNode.getChildNode(pathComponent);
            if (child != null) {
                currentNode = child;
            } else {
                RepositoryNode newChild = new RepositoryNode(pathComponent);
                newChild.setParent(currentNode);
                currentNode.addChild(newChild);
                currentNode = newChild;
            }
            endIndex = loggerName.indexOf(46, beginIndex);
        }
        String leafName = loggerName.substring(beginIndex, loggerName.length());
        RepositoryNode leafNode = new RepositoryNode(leafName, logger);
        leafNode.setParent(currentNode);
        currentNode.addChild(leafNode);
        this.leafNodeHashtable.put(loggerName, leafNode);
    }

    public void setLevel(String name, Level level) {
        RepositoryNode leafNode = (RepositoryNode)this.leafNodeHashtable.get(name);
        if (leafNode != null) {
            leafNode.logger.setLevel(level);
        } else {
            int beginIndex = 0;
            int endIndex = name.indexOf(46);
            int nameLength = name.length();
            RepositoryNode currentNode = this.rootNode;
            while (beginIndex < nameLength && currentNode != null) {
                if (endIndex == -1) {
                    endIndex = nameLength;
                }
                String pathComponent = name.substring(beginIndex, endIndex);
                beginIndex = endIndex + 1;
                RepositoryNode child = currentNode.getChildNode(pathComponent);
                if (child != null) {
                    currentNode = child;
                } else {
                    RepositoryNode newChild = new RepositoryNode(pathComponent);
                    newChild.setParent(currentNode);
                    currentNode.addChild(newChild);
                    currentNode = newChild;
                }
                endIndex = name.indexOf(46, beginIndex);
            }
            if (currentNode != null) {
                currentNode.level = level;
            }
        }
    }

    public Level getEffectiveLevel(Logger logger) {
        Level effectiveLevel = null;
        RepositoryNode currentNode = (RepositoryNode)this.leafNodeHashtable.get(logger.getName());
        while (effectiveLevel == null && currentNode != null) {
            effectiveLevel = currentNode.getLevel();
            currentNode = currentNode.parent;
        }
        return effectiveLevel;
    }

    public boolean contains(String name) {
        return this.leafNodeHashtable.get(name) != null;
    }

    public int numberOfLeafNodes() {
        return this.leafNodeHashtable.size();
    }

    public void reset() {
        this.rootNode.removeAllChildren();
        Logger rootLogger = this.rootNode.logger;
        rootLogger.resetLogger();
        rootLogger.setLevel(Level.DEBUG);
        this.leafNodeHashtable.clear();
    }

    public void shutdown() {
        Enumeration leafNodes = this.leafNodeHashtable.elements();
        while (leafNodes.hasMoreElements()) {
            RepositoryNode node = (RepositoryNode)leafNodes.nextElement();
            Logger logger = node.getLogger();
            if (logger == null) continue;
            try {
                logger.close();
            }
            catch (IOException e) {
                System.err.println("Failed to close logger " + logger.getName());
            }
        }
    }
}

