/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import net.sf.microlog.midp.RecordStoreLogLoader;
import net.sf.microproperties.midp.MidletProperties;

public class RecordStoreLogViewer
extends MIDlet
implements CommandListener {
    private static final int MAX_NAME_LENGTH = 32;
    private final Display display;
    private final Form logScreen;
    private final Form preferenceScreen;
    private final TextField nameField;
    private final Command loadLogCommand = new LoadLogCommand();
    private final Command clearLogCommand = new ClearLogCommand();
    private final Command exitCommand = new ExitCommand();
    private final Command preferenceCommand = new PreferenceCommand();
    private final Command preferenceOkCommand = new PreferenceOkCommand();
    private final Command preferenceCancelCommand = new PreferenceCancelCommand();
    private final Command switchComparatorCommand = new SwitchComparatorCommand((AbstractCommand)this.loadLogCommand);
    RecordStoreLogLoader loader;

    public RecordStoreLogViewer() {
        this.display = Display.getDisplay((MIDlet)this);
        this.logScreen = new Form("Log content");
        this.logScreen.addCommand(this.loadLogCommand);
        this.logScreen.addCommand(this.clearLogCommand);
        this.logScreen.addCommand(this.preferenceCommand);
        this.logScreen.addCommand(this.exitCommand);
        this.logScreen.addCommand(this.switchComparatorCommand);
        this.logScreen.setCommandListener((CommandListener)this);
        this.preferenceScreen = new Form("Preferences");
        this.nameField = new TextField("RecordStore name ", null, 32, 0);
        this.preferenceScreen.append((Item)this.nameField);
        this.preferenceScreen.addCommand(this.preferenceOkCommand);
        this.preferenceScreen.addCommand(this.preferenceCancelCommand);
        this.preferenceScreen.addCommand(this.exitCommand);
        this.preferenceScreen.setCommandListener((CommandListener)this);
    }

    protected void startApp() throws MIDletStateChangeException {
        MidletProperties properties = new MidletProperties((MIDlet)this, "/microlog.properties");
        this.loader = new RecordStoreLogLoader(properties);
        this.display.setCurrent((Displayable)this.logScreen);
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
    }

    public void commandAction(Command cmd, Displayable displayable) {
        if (cmd instanceof AbstractCommand) {
            AbstractCommand myCmd = (AbstractCommand)cmd;
            myCmd.execute();
        }
    }

    protected void showInfoAlert(String message, Throwable exception) {
        StringBuffer buffer = new StringBuffer(message);
        if (exception != null) {
            buffer.append("\r\n");
            buffer.append(exception);
        }
        Alert alert = new Alert("Info", buffer.toString(), null, AlertType.INFO);
        this.display.setCurrent(alert, this.display.getCurrent());
    }

    protected class SwitchComparatorCommand
    extends AbstractCommand {
        private final AbstractCommand performThisCommand;

        public SwitchComparatorCommand(AbstractCommand command) {
            super("Switch sort-order", 8, 3);
            this.performThisCommand = command;
        }

        public void execute() {
            RecordStoreLogViewer.this.loader.switchSortOrder();
            if (this.performThisCommand != null) {
                this.performThisCommand.execute();
            }
        }
    }

    protected class PreferenceCancelCommand
    extends AbstractCommand {
        public PreferenceCancelCommand() {
            super("Cancel", 3, 1);
        }

        public void execute() {
            RecordStoreLogViewer.this.display.setCurrent((Displayable)RecordStoreLogViewer.this.logScreen);
        }
    }

    protected class PreferenceOkCommand
    extends AbstractCommand {
        public PreferenceOkCommand() {
            super("OK", 4, 1);
        }

        public void execute() {
            String newName = RecordStoreLogViewer.this.nameField.getString();
            if (newName != null && newName.length() > 0) {
                RecordStoreLogViewer.this.loader.setRecordStoreName(newName);
            } else {
                RecordStoreLogViewer.this.showInfoAlert("Please enter a name.", null);
            }
        }
    }

    protected class ExitCommand
    extends AbstractCommand {
        public ExitCommand() {
            super("Exit", 7, 1);
        }

        public void execute() {
            RecordStoreLogViewer.this.notifyDestroyed();
        }
    }

    protected class PreferenceCommand
    extends AbstractCommand {
        public PreferenceCommand() {
            super("Preferences", 8, 3);
        }

        public void execute() {
            RecordStoreLogViewer.this.nameField.setString(RecordStoreLogViewer.this.loader.getRecordStoreName());
            RecordStoreLogViewer.this.display.setCurrent((Displayable)RecordStoreLogViewer.this.preferenceScreen);
        }
    }

    protected class ClearLogCommand
    extends AbstractCommand {
        public ClearLogCommand() {
            super("Clear", "Clear Log", 8, 2);
        }

        public void execute() {
            RecordStoreLogViewer.this.logScreen.deleteAll();
            RecordStoreLogViewer.this.loader.clearLog();
        }
    }

    protected class LoadLogCommand
    extends AbstractCommand {
        public LoadLogCommand() {
            super("Load", "Load Log", 8, 1);
        }

        public void execute() {
            RecordStoreLogViewer.this.logScreen.deleteAll();
            String logContent = RecordStoreLogViewer.this.loader.getLogContent();
            RecordStoreLogViewer.this.logScreen.append(logContent);
        }
    }

    protected abstract class AbstractCommand
    extends Command {
        public AbstractCommand(String label, int commandType, int priority) {
            super(label, commandType, priority);
        }

        public AbstractCommand(String shortLabel, String longLabel, int commandType, int priority) {
            super(shortLabel, longLabel, commandType, priority);
        }

        public abstract void execute();
    }
}

