/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.bluetooth.server;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.microlog.midp.bluetooth.BluetoothServerListener;
import net.sf.microlog.midp.bluetooth.server.BluetoothStreamReaderThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BluetoothConnectionHandler {
    UTIL;

    private final Map<Integer, BluetoothStreamReaderThread> connectionMap = new ConcurrentHashMap<Integer, BluetoothStreamReaderThread>();
    private AtomicInteger threadCounter = new AtomicInteger(0);
    private AtomicBoolean shutdown = new AtomicBoolean(false);

    Map<Integer, BluetoothStreamReaderThread> getConnectionMapTestOnly() {
        this.threadCounter.set(0);
        return this.connectionMap;
    }

    void removeConnection(int connectionId) {
        this.connectionMap.remove(connectionId);
    }

    void addConnection(BluetoothStreamReaderThread bluetoothConnection) {
        if (!this.shutdown.get()) {
            int connectionId = this.threadCounter.incrementAndGet();
            this.connectionMap.put(connectionId, bluetoothConnection);
            bluetoothConnection.setConnectionId(connectionId);
        }
    }

    void gracefulShutdown(BluetoothServerListener bluetoothServerListener) {
        if (!this.shutdown.get()) {
            this.shutdown.set(true);
            Collection<BluetoothStreamReaderThread> connectionMapValues = this.connectionMap.values();
            for (BluetoothStreamReaderThread bluetoothStreamReaderThread : connectionMapValues) {
                bluetoothStreamReaderThread.closeConnection();
            }
            System.out.println("Number of open connections at shutdown: " + this.connectionMap.size());
            if (bluetoothServerListener != null) {
                bluetoothServerListener.shutdown();
            }
        }
    }
}

