/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.wma;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.MultipartMessage;
import net.sf.microlog.midp.wma.AbstractMessageAppender;

public class MMSBufferAppender
extends AbstractMessageAppender {
    private static final String CONTENT_LOCATION = "contentLocation";
    public static final String CONTENT_ID_PROPERTY = "contentID";
    public static final String MIME_TYPE_PROPERTY = "mimeType";
    public static final String ENCODING_PROPERTY = "encoding";
    public static final String PRIORITY_PROPERTY = "priority";
    public static final String SUBJECT_PROPERTY = "subject";
    public static final String HIGH_PRIORITY = "high";
    public static final String NORMAL_PRIORITY = "normal";
    public static final String LOW_PRIORITY = "low";
    public static final String DEFAULT_SUBJECT = "Microlog log";
    public static final String DEFAULT_PRIORITY = "high";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_MIME_TYPE = "plain/text";
    private static final String DEFAULT_CONTENT_ID = "Microlog";
    private static final String DEFAULT_CONTENT_LOCATION = "Microlog.txt";
    public static final int DEFAULT_MMS_BUFFER_SIZE = 20;
    public static final String[] PROPERTY_NAMES = new String[]{"subject", "priority", "encoding", "mimeType", "contentID", "contentLocation"};
    private final Vector addressVector = new Vector();
    private String subject = "Microlog log";
    private String priority = "high";
    private String encoding = "UTF-8";
    private String mimeType = "plain/text";
    private String contentId = "Microlog";
    private String contentLocation = "Microlog.txt";

    public MMSBufferAppender() {
        super.setBufferSize(20);
        this.lineSeparator = "\r\n";
    }

    public synchronized void open() throws IOException {
        String connectionString = "mms://:sf.net.microlog";
        this.openConnection(connectionString);
        this.logOpen = true;
    }

    synchronized void sendLog(String messageContent) {
        if (this.addressVector != null && this.addressVector.size() > 0) {
            MultipartMessage message = (MultipartMessage)this.messageConnection.newMessage("multipart");
            message.setSubject(this.subject);
            message.setHeader("X-Mms-Priority", this.priority);
            try {
                byte[] byteData = this.encoding != null && this.encoding.length() > 0 ? messageContent.getBytes(this.encoding) : messageContent.getBytes();
                MessagePart messagePart = new MessagePart(byteData, this.mimeType, this.contentId, this.contentLocation, this.encoding);
                message.addMessagePart(messagePart);
                for (int index = 0; index < this.addressVector.size(); ++index) {
                    Object address = this.addressVector.elementAt(index);
                    message.addAddress("to", address.toString());
                }
                this.messageConnection.send((Message)message);
            }
            catch (InterruptedIOException e) {
                System.err.println("Interrupted while sending the log. " + e);
            }
            catch (IOException e) {
                System.err.println("Failed to send the log. " + e);
            }
        } else {
            System.err.println("A message receiver is not set.");
        }
    }

    public void addAddress(String address) throws IllegalArgumentException {
        if (address == null || address != null && address.length() < 1) {
            throw new IllegalArgumentException("The address must not be null and have a length that is greater than 1");
        }
        if (!address.startsWith("mms://")) {
            address = "mms://" + address;
        }
        this.addressVector.addElement(address);
    }

    public void removeAddress(String address) {
        if (address != null && address.length() > 0) {
            this.addressVector.removeElement(address);
        }
    }

    public void removeAllAddreses() {
        this.addressVector.removeAllElements();
    }

    public synchronized void setSubject(String subject) throws IllegalArgumentException {
        if (subject == null) {
            throw new IllegalArgumentException("The subject must not be null.");
        }
        this.subject = subject;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) throws IllegalArgumentException {
        if (priority == null) {
            throw new IllegalArgumentException("The priority must not be null.");
        }
        if (priority.compareTo("high") == 0 || priority.compareTo(NORMAL_PRIORITY) == 0 || priority.compareTo(LOW_PRIORITY) == 0) {
            this.priority = priority;
        }
    }

    public synchronized void setEncoding(String encoding) throws IllegalArgumentException {
        if (encoding == null) {
            throw new IllegalArgumentException("The encoding must not be null.");
        }
        this.encoding = encoding;
    }

    public synchronized void setMimeType(String mimeType) throws IllegalArgumentException {
        if (mimeType == null) {
            throw new IllegalArgumentException("The mimeType msut not be null.");
        }
        this.mimeType = mimeType;
    }

    public synchronized void setContentId(String contentId) throws IllegalArgumentException {
        if (contentId == null) {
            throw new IllegalArgumentException("The contentId must not be null.");
        }
        this.contentId = contentId;
    }

    public synchronized void setContentLocation(String contentLocation) throws IllegalArgumentException {
        if (contentLocation == null) {
            throw new IllegalArgumentException("The contentLocation must not be null.");
        }
        this.contentLocation = contentLocation;
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
        super.setProperty(name, value);
        if (name.equals(SUBJECT_PROPERTY)) {
            this.setSubject(value);
        } else if (name.equals(PRIORITY_PROPERTY)) {
            this.setPriority(value);
        } else if (name.equals(ENCODING_PROPERTY)) {
            this.setEncoding(value);
        } else if (name.equals(MIME_TYPE_PROPERTY)) {
            this.setMimeType(value);
        } else if (name.equals(CONTENT_ID_PROPERTY)) {
            this.setContentId(value);
        } else if (name.equals(CONTENT_LOCATION)) {
            this.setContentLocation(value);
        }
    }
}

