/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core.format.command;

import net.sf.microlog.core.Level;
import net.sf.microlog.core.StringUtil;
import net.sf.microlog.core.format.command.FormatCommandInterface;

public class CategoryFormatCommand
implements FormatCommandInterface {
    public static final int FULL_CLASS_NAME_SPECIFIER = -1;
    public static final int DEFAULT_PRECISION_SPECIFIER = 1;
    private int precisionSpecifier = 1;

    public String execute(String clientID, String name, long time, Level level, Object message, Throwable throwable) {
        String convertedData = "";
        if (name != null) {
            convertedData = this.precisionSpecifier == -1 ? name : StringUtil.extractPartialClassName(name, this.precisionSpecifier);
        }
        return convertedData;
    }

    public void init(String initString) {
        try {
            this.precisionSpecifier = Integer.parseInt(initString);
            System.out.println("Precision specifier for %c is " + this.precisionSpecifier);
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to parse the specifier for the %c pattern " + e);
        }
    }

    public int getPrecisionSpecifier() {
        return this.precisionSpecifier;
    }

    public void setPrecisionSpecifier(int precisionSpecifier) {
        this.precisionSpecifier = precisionSpecifier;
    }
}

