/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core.appender;

import java.io.IOException;
import java.util.Vector;
import net.sf.microlog.core.CyclicBuffer;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;

public class MemoryBufferAppender
extends AbstractAppender {
    public static final String MAX_LOG_ENTRIES_PROPERTY = "maxLogEntries";
    public static final String CYCLIC_BUFFER_PROPERTY = "cyclicBuffer";
    public static final String[] PROPERTY_NAMES = new String[]{"cyclicBuffer", "maxLogEntries"};
    private static final int DEFAULT_MAX_NBR_OF_ENTRIES = 20;
    private CyclicBuffer cyclicBuffer;
    private boolean cyclicBufferEnabled;

    public MemoryBufferAppender() {
        this(20, true);
    }

    public MemoryBufferAppender(int maxNbrOfEntries, boolean cyclicBufferEnabled) {
        if (maxNbrOfEntries <= 0) {
            maxNbrOfEntries = 20;
        }
        this.cyclicBufferEnabled = cyclicBufferEnabled;
        this.cyclicBuffer = new CyclicBuffer(maxNbrOfEntries);
    }

    public int getMaxNbrOfEntries() {
        return this.cyclicBuffer.getBufferSize();
    }

    public boolean isCyclicBuffer() {
        return this.cyclicBufferEnabled;
    }

    public Vector getLogBuffer() {
        return this.cyclicBuffer.getAsVector();
    }

    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            if (this.cyclicBuffer.length() >= this.cyclicBuffer.getBufferSize()) {
                if (this.cyclicBufferEnabled) {
                    this.cyclicBuffer.add(this.formatter.format(clientID, name, time, level, message, t));
                }
            } else {
                this.cyclicBuffer.add(this.formatter.format(clientID, name, time, level, message, t));
            }
        } else if (this.formatter == null) {
            System.err.println("Please set a formatter.");
        }
    }

    public void clear() {
        this.cyclicBuffer.clear();
    }

    public void close() throws IOException {
        this.logOpen = false;
    }

    public void open() throws IOException {
        this.logOpen = true;
    }

    public long getLogSize() {
        return this.cyclicBuffer.length();
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
        int maxNbrOfEntries;
        super.setProperty(name, value);
        if (name.equals(CYCLIC_BUFFER_PROPERTY)) {
            this.cyclicBufferEnabled = "true".equalsIgnoreCase(value);
        } else if (name.equals(MAX_LOG_ENTRIES_PROPERTY) && (maxNbrOfEntries = Integer.parseInt(value)) > 0) {
            this.cyclicBuffer = new CyclicBuffer(maxNbrOfEntries);
        }
    }
}

