/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core.appender;

import java.io.IOException;
import java.io.PrintStream;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;

public class ConsoleAppender
extends AbstractAppender {
    private PrintStream console = System.out;

    public ConsoleAppender() {
    }

    public ConsoleAppender(PrintStream console) throws IllegalArgumentException {
        if (console == null) {
            throw new IllegalArgumentException("The console must not be null.");
        }
        this.console = console;
    }

    public final void setConsole(PrintStream console) throws IllegalArgumentException {
        if (console == null) {
            throw new IllegalArgumentException("The console must not be null.");
        }
        this.console = console;
    }

    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable throwable) {
        if (this.logOpen && this.formatter != null) {
            this.console.println(this.formatter.format(clientID, name, time, level, message, throwable));
            if (throwable != null) {
                throwable.printStackTrace();
            }
        } else if (this.formatter == null) {
            System.err.println("Please set a formatter.");
        }
    }

    public void clear() {
        if (this.console != null) {
            this.console.flush();
        }
    }

    public void close() throws IOException {
        if (this.console != null) {
            this.console.flush();
        }
        this.logOpen = false;
    }

    public void open() throws IOException {
        this.logOpen = true;
    }

    public long getLogSize() {
        return -1L;
    }
}

