/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;

public abstract class AbstractFileAppender
extends AbstractAppender {
    public static final String FILE_NAME_PROPERTY = "filename";
    public static final String LINE_SEPARATOR_PROPERTY = "lineseparator";
    public static final String DEFAULT_FILENAME = "microlog.txt";
    public static final String DEFAULT_LINE_SEPARATOR = "\r\n";
    public static final int DEFAULT_STRING_BUFFER_SIZE = 256;
    public static final String[] PROPERTY_NAMES = new String[]{"filename", "lineseparator"};
    public static final String[] DEFAULT_VALUES = new String[]{"microlog.txt", "\r\n"};
    protected String lineSeparator = System.getProperty("line.separator");
    protected String directory;
    protected String fileName = "microlog.txt";
    protected OutputStream outputStream;
    protected boolean fileConnectionIsSet = false;

    public synchronized void open() throws IOException {
        if (!this.fileConnectionIsSet) {
            String fileURI = this.createFileURI();
            this.createFile(fileURI);
            this.fileConnectionIsSet = true;
        }
        this.openOutputStream();
        this.logOpen = true;
    }

    protected abstract String createFileURI();

    protected abstract void createFile(String var1) throws IOException;

    protected abstract void openOutputStream() throws IOException;

    public abstract void clear();

    public abstract void close() throws IOException;

    public synchronized void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            String logString = this.formatter.format(clientID, name, time, level, message, t);
            try {
                byte[] stringData = logString.getBytes();
                this.outputStream.write(stringData);
                if (this.lineSeparator == null) {
                    this.lineSeparator = DEFAULT_LINE_SEPARATOR;
                }
                this.outputStream.write(this.lineSeparator.getBytes());
                this.outputStream.flush();
            }
            catch (IOException e) {
                System.err.println("Failed to log message " + e);
            }
        }
    }

    public abstract long getLogSize();

    public synchronized String getFileName() {
        return this.fileName;
    }

    public synchronized void setFileName(String fileName) throws IllegalArgumentException {
        if (fileName == null) {
            throw new IllegalArgumentException("The filename must not be null.");
        }
        this.fileName = fileName;
    }

    public synchronized String getLineSeparator() {
        return this.lineSeparator;
    }

    public synchronized void setLineSeparator(String lineSeparator) throws IllegalArgumentException {
        if (lineSeparator == null) {
            throw new IllegalArgumentException("The line separator must not be null.");
        }
        this.lineSeparator = lineSeparator;
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
        super.setProperty(name, value);
        if (name.equals(FILE_NAME_PROPERTY)) {
            this.setFileName(value);
        } else if (name.equals(LINE_SEPARATOR_PROPERTY)) {
            this.setLineSeparator(value);
        }
    }
}

