/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SyslogMessage {
    public static final int DEFAULT_SYSLOG_PORT = 514;
    public static final int DEFAULT_MESSAGE_BUFFER_SIZE = 128;
    public static final byte FACILITY_KERNAL_MESSAGE = 0;
    public static final byte FACILITY_USER_LEVEL_MESSAGE = 1;
    public static final byte FACILITY_MAIL_SYSTEM = 2;
    public static final byte FACILITY_SYSTEM_DAEMONS = 3;
    public static final byte FACILITY_SECURITY_MESSAGE = 4;
    public static final byte FACILITY_LOG_AUDIT = 13;
    public static final byte FACILITY_LOG_ALERT = 14;
    public static final byte FACILITY_LOCAL_USE_0 = 16;
    public static final byte FACILITY_LOCAL_USE_1 = 17;
    public static final byte FACILITY_LOCAL_USE_2 = 18;
    public static final byte FACILITY_LOCAL_USE_3 = 19;
    public static final byte FACILITY_LOCAL_USE_4 = 20;
    public static final byte FACILITY_LOCAL_USE_5 = 21;
    public static final byte FACILITY_LOCAL_USE_6 = 22;
    public static final byte FACILITY_LOCAL_USE_7 = 23;
    public static final byte SEVERITY_EMERGENCY = 0;
    public static final byte SEVERITY_ALERT = 1;
    public static final byte SEVERITY_CRITICAL = 2;
    public static final byte SEVERITY_ERROR = 3;
    public static final byte SEVERITY_WARNING = 4;
    public static final byte SEVERITY_NOTICE = 5;
    public static final byte SEVERITY_INFORMATIONAL = 6;
    public static final byte SEVERITY_DEBUG = 7;
    public static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private byte facility = 1;
    private byte severity = (byte)7;
    private boolean header;
    private final StringBuffer messageStringBuffer = new StringBuffer(128);
    private String hostname;
    String tag;

    public String createMessageData(String message) {
        this.messageStringBuffer.delete(0, this.messageStringBuffer.length());
        this.messageStringBuffer.append('<');
        int priority = this.facility * 8 + this.severity;
        this.messageStringBuffer.append(priority);
        this.messageStringBuffer.append('>');
        if (this.header) {
            long currentTime = System.currentTimeMillis();
            this.calendar.setTime(new Date(currentTime));
            this.messageStringBuffer.append(MONTHS[this.calendar.get(2)]);
            this.messageStringBuffer.append(' ');
            int dayOfMonth = this.calendar.get(5);
            if (dayOfMonth < 10) {
                this.messageStringBuffer.append('0');
            }
            this.messageStringBuffer.append(dayOfMonth);
            this.messageStringBuffer.append(' ');
            int hour = this.calendar.get(11);
            if (hour < 10) {
                this.messageStringBuffer.append('0');
            }
            this.messageStringBuffer.append(hour);
            this.messageStringBuffer.append(':');
            int minute = this.calendar.get(12);
            if (minute < 10) {
                this.messageStringBuffer.append('0');
            }
            this.messageStringBuffer.append(minute);
            this.messageStringBuffer.append(':');
            int second = this.calendar.get(13);
            if (second < 10) {
                this.messageStringBuffer.append('0');
            }
            this.messageStringBuffer.append(second);
            this.messageStringBuffer.append(' ');
            this.messageStringBuffer.append(this.hostname);
        }
        this.messageStringBuffer.append(' ');
        this.messageStringBuffer.append(this.tag);
        this.messageStringBuffer.append(": ");
        this.messageStringBuffer.append(message);
        return this.messageStringBuffer.toString();
    }

    public void setFacility(byte facility) {
        if (facility < 0 || facility > 23) {
            throw new IllegalArgumentException("Not a valid facility.");
        }
        this.facility = facility;
    }

    public byte getFacility() {
        return this.facility;
    }

    public void setSeverity(byte severity) throws IllegalArgumentException {
        if (severity < 0 || severity > 7) {
            throw new IllegalArgumentException("Not a valid severity.");
        }
        this.severity = severity;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public void setHostname(String hostname) throws IllegalArgumentException {
        if (hostname == null) {
            throw new IllegalArgumentException("The hostname must not be null.");
        }
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setTag(String tag) throws IllegalArgumentException {
        if (tag == null || tag != null && (tag.length() < 1 || tag.length() > 32)) {
            throw new IllegalArgumentException("The tag must not be null, the length between 1..32");
        }
        this.tag = tag;
    }
}

