/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core;

import java.util.Hashtable;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.Logger;

class RepositoryNode {
    protected String name;
    protected RepositoryNode parent;
    protected Hashtable children = new Hashtable(17);
    protected Logger logger;
    protected Level level;

    public RepositoryNode(String name) {
        this.name = name;
    }

    public RepositoryNode(String name, Logger logger) {
        this.name = name;
        this.logger = logger;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChild(RepositoryNode child) {
        this.children.put(child.getName(), child);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Level getLevel() {
        Level nodeLevel = this.level;
        if (this.logger != null) {
            nodeLevel = this.logger.getLevel();
        }
        return nodeLevel;
    }

    public RepositoryNode getChildNode(String name) {
        return (RepositoryNode)this.children.get(name);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public RepositoryNode getParent() {
        return this.parent;
    }

    public void setParent(RepositoryNode parent) {
        this.parent = parent;
    }
}

