/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sf.microlog.core.Appender;
import net.sf.microlog.core.Formatter;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.Logger;
import net.sf.microlog.core.LoggerFactory;
import net.sf.microlog.core.LoggerRepository;
import net.sf.microlog.core.StringUtil;
import net.sf.microproperties.JarFileProperties;
import net.sf.microproperties.Properties;

public class PropertyConfigurator {
    public static final String FORMATTER_PROPERTY = "formatter";
    public static final String LOGGER_PREFIX_KEY = "microlog.logger";
    public static final String ROOT_LOGGER_KEY = "microlog.rootLogger";
    public static final String FORMATTER_KEY = "microlog.formatter";
    public static final String APPENDER_KEY = "microlog.appender";
    public static final String LOG_LEVEL_KEY = "microlog.level";
    public static final String LOG4J_PROPERTY_DELIMITER = ",";
    public static final String DEFAULT_PROPERTY_FILE = "/microlog.properties";
    public static final String DEFAULT_LOG_LEVEL_STRING = "DEBUG";
    public static final Level DEFAULT_LOG_LEVEL = Level.DEBUG;
    public static final String PROPERTY_DELIMETER = ";";
    public static final String[] FORMATTER_ALIASES = new String[]{"SimpleFormatter", "PatternFormatter"};
    public static final String[] FORMATTER_CLASS_NAMES = new String[]{"net.sf.microlog.core.format.SimpleFormatter", "net.sf.microlog.core.format.PatternFormatter"};
    public static final String[] APPENDER_ALIASES = new String[]{"ConsoleAppender", "MemoryBufferAppender", "BluetoothSerialAppender", "CanvasAppender", "DatagramAppender", "HttpAppender", "FileAppender", "FormAppender", "MMSBufferAppender", "RecordStoreAppender", "SerialAppender", "SMSBufferAppender", "SocketAppender", "SyslogAppender"};
    public static final String[] APPENDER_CLASS_NAMES = new String[]{"net.sf.microlog.core.appender.ConsoleAppender", "net.sf.microlog.core.appender.MemoryBufferAppender", "net.sf.microlog.midp.bluetooth.BluetoothSerialAppender", "net.sf.microlog.midp.appender.CanvasAppender", "net.sf.microlog.midp.appender.DatagramAppender", "net.sf.microlog.midp.appender.HttpAppender", "net.sf.microlog.midp.file.FileAppender", "net.sf.microlog.midp.appender.FormAppender", "net.sf.microlog.midp.wma.MMSBufferAppender", "net.sf.microlog.midp.appender.RecordStoreAppender", "net.sf.microlog.midp.appender.SerialAppender", "net.sf.microlog.midp.wma.SMSBufferAppender", "net.sf.microlog.midp.appender.SocketAppender", "net.sf.microlog.midp.appender.SyslogAppender"};
    static Hashtable formatterMap = new Hashtable(7);
    static Hashtable appenderMap = new Hashtable(37);
    protected LoggerRepository loggerRepository;

    public PropertyConfigurator() {
        for (int formatterNo = 0; formatterNo < FORMATTER_ALIASES.length; ++formatterNo) {
            formatterMap.put(FORMATTER_ALIASES[formatterNo], FORMATTER_CLASS_NAMES[formatterNo]);
        }
        for (int appenderNo = 0; appenderNo < APPENDER_ALIASES.length; ++appenderNo) {
            appenderMap.put(APPENDER_ALIASES[appenderNo], APPENDER_CLASS_NAMES[appenderNo]);
        }
        this.loggerRepository = LoggerFactory.getLoggerRepository();
    }

    public static void configure() {
        PropertyConfigurator.configure(DEFAULT_PROPERTY_FILE);
    }

    public static void configure(String fileName) {
        JarFileProperties jarFileProperties = new JarFileProperties();
        System.out.println("Trying to load properties from " + fileName);
        try {
            jarFileProperties.load(fileName);
            PropertyConfigurator configurator = new PropertyConfigurator();
            configurator.configure(jarFileProperties);
        }
        catch (IOException e) {
            System.err.println("Failed to load properties file: " + fileName);
        }
    }

    public void configure(Properties properties) {
        String rootLogger = properties.getProperty(ROOT_LOGGER_KEY);
        if (rootLogger != null) {
            this.configureLog4jStyle(properties);
        } else {
            this.configureMicrologClassicStyle(properties);
        }
    }

    public static void addAppenderAlias(Appender appender) {
        String fullyQualifiedClassName = appender.getClass().getName();
        String aliasName = StringUtil.extractPartialClassName(fullyQualifiedClassName, 1);
        appenderMap.put(aliasName, fullyQualifiedClassName);
    }

    public static void addFormatterAlias(Formatter formatter) {
        String fullyQualifiedClassName = formatter.getClass().getName();
        String aliasName = StringUtil.extractPartialClassName(fullyQualifiedClassName, 1);
        formatterMap.put(aliasName, fullyQualifiedClassName);
    }

    protected void configureLog4jStyle(Properties properties) {
        String rootLoggerProperty = properties.getProperty(ROOT_LOGGER_KEY);
        int endIndex = rootLoggerProperty.indexOf(LOG4J_PROPERTY_DELIMITER);
        String levelString = DEFAULT_LOG_LEVEL_STRING;
        levelString = endIndex != -1 ? rootLoggerProperty.substring(0, endIndex) : rootLoggerProperty;
        Logger rootLogger = this.loggerRepository.getRootLogger();
        Level rootLogLevel = this.setRootLevel(levelString);
        this.doConfigureHierarchyLogLevels(properties);
        int beginIndex = 0;
        if (rootLogLevel != null) {
            beginIndex = endIndex + 1;
            endIndex = rootLoggerProperty.indexOf(LOG4J_PROPERTY_DELIMITER, beginIndex);
        } else {
            rootLogger.setLevel(DEFAULT_LOG_LEVEL);
        }
        if (endIndex == -1) {
            endIndex = rootLoggerProperty.length();
        }
        while (beginIndex < rootLoggerProperty.length()) {
            String appenderName = rootLoggerProperty.substring(beginIndex, endIndex).trim();
            this.doConfigureAppender(rootLogger, appenderName, properties);
            beginIndex = endIndex + 1;
            if ((endIndex = rootLoggerProperty.indexOf(LOG4J_PROPERTY_DELIMITER, beginIndex)) != -1) continue;
            endIndex = rootLoggerProperty.length();
        }
    }

    protected void doConfigureHierarchyLogLevels(Properties properties) {
        Enumeration propertyEnumeration = properties.keys();
        while (propertyEnumeration.hasMoreElements()) {
            String propertyKey = (String)propertyEnumeration.nextElement();
            if (!propertyKey.startsWith(LOGGER_PREFIX_KEY)) continue;
            String path = propertyKey.substring(LOGGER_PREFIX_KEY.length() + 1);
            String levelString = properties.getProperty(propertyKey);
            Level level = this.stringToLevel(levelString);
            if (level != null) {
                System.out.println("Setting level " + level + " to path " + path);
                this.loggerRepository.setLevel(path, level);
                continue;
            }
            System.err.println("Level " + levelString + " is not a valid level.");
        }
    }

    protected void doConfigureAppender(Logger logger, String appenderName, Properties properties) {
        Appender appender = this.createAppender(appenderName, properties);
        if (appender != null) {
            System.out.println("Adding appender " + appender);
            Formatter formatter = this.doConfigureFormatter(appenderName, properties);
            if (formatter != null) {
                appender.setFormatter(formatter);
            }
            this.setAppenderSpecificProperties(appenderName, properties, appender);
            logger.addAppender(appender);
        }
    }

    private Formatter doConfigureFormatter(String appenderName, Properties properties) {
        String[] formatterProperties;
        Formatter formatter = this.createFormatter(appenderName, properties);
        if (formatter != null && (formatterProperties = formatter.getPropertyNames()) != null && formatterProperties.length > 0) {
            for (int property = 0; property < formatterProperties.length; ++property) {
                StringBuffer propertyKeyBuffer = new StringBuffer(64);
                propertyKeyBuffer.append(APPENDER_KEY);
                propertyKeyBuffer.append('.');
                propertyKeyBuffer.append(appenderName);
                propertyKeyBuffer.append('.');
                propertyKeyBuffer.append(FORMATTER_PROPERTY);
                propertyKeyBuffer.append('.');
                String propertyName = formatterProperties[property];
                propertyKeyBuffer.append(propertyName);
                String propertyKey = propertyKeyBuffer.toString();
                String propertyValue = properties.getProperty(propertyKey);
                if (propertyValue == null) continue;
                System.out.println("Setting property " + propertyName + "=" + propertyValue);
                formatter.setProperty(propertyName, propertyValue);
            }
        }
        return formatter;
    }

    protected Appender createAppender(String appenderName, Properties properties) {
        String appenderClassNameProperty = "microlog.appender." + appenderName;
        String appenderClassName = properties.getProperty(appenderClassNameProperty);
        Appender appender = null;
        if (appenderClassName != null) {
            appenderClassName = this.checkForAliasAppender(appenderClassName);
            try {
                Class<?> appenderClass = Class.forName(appenderClassName);
                appender = (Appender)appenderClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println("microlog: Could not find appender class " + appenderName);
            }
            catch (InstantiationException e) {
                System.err.println("microlog: Could not instantiate appender class " + appenderName);
            }
            catch (IllegalAccessException e) {
                System.err.println("microlog: Not allowed to create appender class " + appenderName);
            }
        }
        return appender;
    }

    private String checkForAliasAppender(String appenderName) {
        String className = appenderName;
        String aliasClassName = (String)appenderMap.get(appenderName);
        if (aliasClassName != null) {
            className = aliasClassName;
        }
        return className;
    }

    protected Formatter createFormatter(String appenderName, Properties properties) {
        System.out.println("createFormatter: " + appenderName);
        StringBuffer formatterKey = new StringBuffer(64);
        formatterKey.append(APPENDER_KEY);
        formatterKey.append('.');
        formatterKey.append(appenderName);
        formatterKey.append('.');
        formatterKey.append(FORMATTER_PROPERTY);
        String formatterClassName = properties.getProperty(formatterKey.toString());
        Formatter formatter = null;
        if (formatterClassName != null) {
            formatterClassName = this.checkForAliasFormatter(formatterClassName);
            try {
                Class<?> formatterClass = Class.forName(formatterClassName);
                formatter = (Formatter)formatterClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println("microlog: Could not find the formatter class " + appenderName);
            }
            catch (InstantiationException e) {
                System.err.println("microlog: Could not find the formatter class " + appenderName);
            }
            catch (IllegalAccessException e) {
                System.err.println("microlog: Could not find the formatter class " + appenderName);
            }
        } else {
            System.err.println("microlog: No formatter class defined");
        }
        return formatter;
    }

    private String checkForAliasFormatter(String formatterName) {
        String className = formatterName;
        String aliasClassName = (String)formatterMap.get(formatterName);
        if (aliasClassName != null) {
            className = aliasClassName;
        }
        return className;
    }

    protected void setAppenderSpecificProperties(String appenderName, Properties properties, Appender appender) {
        String[] appenderSpecificProperties = appender.getPropertyNames();
        StringBuffer propertyNameBuffer = new StringBuffer(64);
        if (appenderSpecificProperties != null && appenderSpecificProperties.length > 0) {
            for (int index = 0; index < appenderSpecificProperties.length; ++index) {
                propertyNameBuffer.delete(0, propertyNameBuffer.length());
                propertyNameBuffer.append(APPENDER_KEY);
                propertyNameBuffer.append('.');
                if (appenderName != null) {
                    propertyNameBuffer.append(appenderName);
                    propertyNameBuffer.append('.');
                }
                propertyNameBuffer.append(appenderSpecificProperties[index]);
                String propertyName = propertyNameBuffer.toString();
                String propertyValue = properties.getProperty(propertyName);
                if (propertyValue == null) continue;
                appender.setProperty(appenderSpecificProperties[index], propertyValue);
            }
        }
    }

    private void configureMicrologClassicStyle(Properties properties) {
        this.doConfigureLogLevel(properties);
        this.configureAppender(properties);
        this.configureFormatter(properties);
    }

    private void doConfigureLogLevel(Properties properties) {
        String levelString = properties.getProperty(LOG_LEVEL_KEY, DEFAULT_LOG_LEVEL_STRING);
        this.setRootLevel(levelString);
    }

    private Level setRootLevel(String levelString) {
        Level level = this.stringToLevel(levelString);
        if (level != null) {
            Logger logger = this.loggerRepository.getRootLogger();
            logger.setLevel(level);
        } else {
            System.err.println("Level " + levelString + " is not a valid level.");
        }
        return level;
    }

    private Level stringToLevel(String levelString) {
        Level level = null;
        if (levelString.equalsIgnoreCase("FATAL")) {
            level = Level.FATAL;
        } else if (levelString.equalsIgnoreCase("ERROR")) {
            level = Level.ERROR;
        } else if (levelString.equalsIgnoreCase("WARN")) {
            level = Level.WARN;
        } else if (levelString.equalsIgnoreCase("INFO")) {
            level = Level.INFO;
        } else if (levelString.equalsIgnoreCase(DEFAULT_LOG_LEVEL_STRING)) {
            level = Level.DEBUG;
        } else if (levelString.equalsIgnoreCase("TRACE")) {
            level = Level.TRACE;
        }
        return level;
    }

    void configureAppender(Properties properties) {
        Logger logger = this.loggerRepository.getRootLogger();
        logger.removeAllAppenders();
        String appenderString = properties.getProperty(APPENDER_KEY);
        if (appenderString != null && appenderString.length() > 0) {
            try {
                int delimiterPos = appenderString.indexOf(PROPERTY_DELIMETER);
                if (delimiterPos == -1) {
                    appenderString = this.checkForAliasAppender(appenderString);
                    Class<?> appenderClass = Class.forName(appenderString);
                    Appender appender = (Appender)appenderClass.newInstance();
                    String appenderName = StringUtil.extractPartialClassName(appenderString, 1);
                    this.setAppenderSpecificProperties(appenderName, properties, appender);
                    logger.addAppender(appender);
                } else {
                    int startPos = 0;
                    boolean finished = false;
                    do {
                        int endPos;
                        if ((delimiterPos = appenderString.indexOf(PROPERTY_DELIMETER, startPos)) == -1) {
                            endPos = appenderString.length();
                            finished = true;
                        } else {
                            endPos = delimiterPos;
                        }
                        String singleAppenderString = appenderString.substring(startPos, endPos);
                        startPos = endPos + 1;
                        if (singleAppenderString.length() <= 0) continue;
                        singleAppenderString = this.checkForAliasAppender(singleAppenderString);
                        Class<?> appenderClass = Class.forName(singleAppenderString);
                        Appender appender = (Appender)appenderClass.newInstance();
                        String appenderName = StringUtil.extractPartialClassName(singleAppenderString, 1);
                        this.setAppenderSpecificProperties(appenderName, properties, appender);
                        logger.addAppender(appender);
                        System.out.println("Added appender " + appender);
                    } while (!finished);
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Did not find the appender class. " + e);
            }
            catch (InstantiationException e) {
                System.err.println("Did not manage to initiate the appender class. " + e);
            }
            catch (IllegalAccessException e) {
                System.err.println("Did not have access to create the appender class. " + e);
            }
        }
    }

    private void configureFormatter(Properties properties) {
        Logger logger = this.loggerRepository.getRootLogger();
        String className = properties.getProperty(FORMATTER_KEY);
        Formatter formatter = null;
        if (className != null) {
            try {
                className = this.checkForAliasFormatter(className);
                Class<?> formatterClass = Class.forName(className);
                formatter = (Formatter)formatterClass.newInstance();
                System.out.println("Using formatter " + formatter.getClass());
            }
            catch (ClassNotFoundException e) {
                System.err.println("Did not find the formatter class. " + e);
            }
            catch (InstantiationException e) {
                System.err.println("Did not manage to initiate the formatter class. " + e);
            }
            catch (IllegalAccessException e) {
                System.err.println("Did not have access to create the formatter class. " + e);
            }
        }
        if (formatter != null) {
            String[] formatterProperties = formatter.getPropertyNames();
            if (formatterProperties != null && formatterProperties.length > 0) {
                for (int property = 0; property < formatterProperties.length; ++property) {
                    String propertyName = formatterProperties[property];
                    String patternClassName = className.substring(className.lastIndexOf(46) + 1);
                    String propertyValue = properties.getProperty("microlog.formatter." + patternClassName + '.' + propertyName);
                    if (propertyValue == null) continue;
                    formatter.setProperty(propertyName, propertyValue);
                }
            }
            int nofAppenders = logger.getNumberOfAppenders();
            for (int index = 0; index < nofAppenders; ++index) {
                Appender appender = logger.getAppender(index);
                if (appender == null) continue;
                appender.setFormatter(formatter);
            }
        }
    }
}

