/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.bluetooth.server;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.bluetooth.RemoteDevice;
import net.sf.microlog.midp.bluetooth.BluetoothServerListener;
import net.sf.microlog.midp.bluetooth.server.BluetoothConnectionHandler;
import net.sf.microlog.midp.bluetooth.server.BluetoothStreamReaderThread;

public class BluetoothStreamReaderThreadImpl
implements Runnable,
BluetoothStreamReaderThread {
    private final BluetoothServerListener serverListener;
    private final DataInputStream input;
    private final RemoteDevice remoteDevice;
    private int connectionId;
    private AtomicBoolean connectionClosed = new AtomicBoolean(false);
    private String name;
    private String address;

    public BluetoothStreamReaderThreadImpl(BluetoothServerListener listener, DataInputStream input, RemoteDevice remoteDevice) {
        this.serverListener = listener;
        this.input = input;
        this.remoteDevice = remoteDevice;
    }

    public synchronized void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.name = this.remoteDevice.getFriendlyName(false);
            this.address = this.remoteDevice.getBluetoothAddress();
            System.out.println("New client connected, Bluetooth address: " + this.address + (this.name == null ? "" : " - name:" + this.name));
            this.serverListener.clientAccepted(this.address, this.name);
            boolean stopReading = false;
            String message = this.input.readUTF();
            while (!stopReading && message != null) {
                if (message.compareTo("[STOP]") == 0) {
                    BluetoothConnectionHandler.UTIL.gracefulShutdown(this.serverListener);
                    break;
                }
                this.serverListener.messageReceived(message);
                message = this.input.readUTF();
            }
        }
        catch (IOException io) {
            System.err.println("Failed data from the client. It is probably disconnected. " + io);
        }
        finally {
            this.closeConnection();
        }
    }

    public synchronized void closeConnection() {
        if (!this.connectionClosed.get()) {
            this.serverListener.clientDisconnected(this.address, this.name);
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (IOException io) {
                    System.err.println("Failed to close: " + io);
                }
            }
            BluetoothConnectionHandler.UTIL.removeConnection(this.connectionId);
            this.connectionClosed.set(true);
        }
    }
}

