/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.bluetooth.server;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import net.sf.microlog.midp.bluetooth.BluetoothServerListener;
import net.sf.microlog.midp.bluetooth.server.BluetoothConnectionHandler;
import net.sf.microlog.midp.bluetooth.server.BluetoothStreamReaderThreadImpl;
import net.sf.microlog.midp.bluetooth.server.DefaultServerListenerImpl;

public class BluetoothSerialServerThread
implements Runnable {
    private static final String DEFAULT_BT_UUID_STRING = "80d41dda939840c41b605d69043dab6";
    private final Executor executor = Executors.newCachedThreadPool();
    private final LocalDevice local;
    private BluetoothServerListener serverListener = new DefaultServerListenerImpl();

    public BluetoothSerialServerThread() {
        this.local = this.getDiscoverableLocalDevice();
    }

    public String getLocalBtAddress() {
        return this.local.getBluetoothAddress();
    }

    private LocalDevice getDiscoverableLocalDevice() {
        LocalDevice local;
        try {
            local = LocalDevice.getLocalDevice();
            if (!local.setDiscoverable(10390323)) {
                System.out.println("Failed to change to the discoverable mode");
            }
        }
        catch (BluetoothStateException bse) {
            throw new IllegalStateException("Failed to init the Bluetooth connection. " + (Object)((Object)bse));
        }
        return local;
    }

    public void setServerListener(BluetoothServerListener serverListener) {
        if (serverListener != null) {
            this.serverListener = serverListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            StreamConnectionNotifier notifier = null;
            StreamConnection connection = null;
            try {
                notifier = this.createNotifier();
                this.notifyListenerServerStarted(notifier);
                connection = notifier.acceptAndOpen();
                RemoteDevice remoteDevice = RemoteDevice.getRemoteDevice((Connection)connection);
                BluetoothStreamReaderThreadImpl bluetoothConnection = new BluetoothStreamReaderThreadImpl(this.serverListener, connection.openDataInputStream(), remoteDevice);
                BluetoothConnectionHandler.UTIL.addConnection(bluetoothConnection);
                this.executor.execute(bluetoothConnection);
                continue;
            }
            catch (IOException io) {
                System.err.println("Unable to start service: " + io);
                continue;
            }
            finally {
                try {
                    if (notifier != null) {
                        notifier.close();
                    }
                    if (connection == null) continue;
                    connection.close();
                }
                catch (IOException io) {
                    System.err.println("Failed to close: " + io);
                }
                continue;
            }
            break;
        }
    }

    private StreamConnectionNotifier createNotifier() throws IOException {
        return (StreamConnectionNotifier)Connector.open((String)"btspp://localhost:80d41dda939840c41b605d69043dab6");
    }

    private void notifyListenerServerStarted(StreamConnectionNotifier notifier) {
        ServiceRecord serviceRecord = this.local.getRecord((Connection)notifier);
        this.serverListener.serverStarted(serviceRecord.getConnectionURL(0, false));
    }
}

