/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.bluetooth;

import java.io.IOException;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;
import net.sf.microlog.midp.bluetooth.BluetoothConnectionHandler;
import net.sf.microlog.midp.bluetooth.BluetoothConnectionHandlerImpl;
import net.sf.microlog.midp.bluetooth.BluetoothRemoteDevice;
import net.sf.microproperties.Properties;

public class BluetoothSerialAppender
extends AbstractAppender {
    public static final String SERVER_URL_STRING = "microlog.appender.BluetoothSerialAppender.serverUrl";
    public static final String BTADDRESS_PROPERTY = "btAddress";
    private BluetoothConnectionHandler bluetoothConnectionHandler = new BluetoothConnectionHandlerImpl();

    public BluetoothSerialAppender() {
    }

    BluetoothSerialAppender(BluetoothConnectionHandler bluetoothConnectionHandler) {
        this.bluetoothConnectionHandler = bluetoothConnectionHandler;
        this.logOpen = true;
    }

    public BluetoothSerialAppender(String serverUrl) {
        this.bluetoothConnectionHandler.setConnectionString(serverUrl);
    }

    public BluetoothSerialAppender(BluetoothRemoteDevice remoteDevice) {
        this.bluetoothConnectionHandler.findAndSetConnectionString(remoteDevice);
    }

    public void clear() {
    }

    public void close() throws IOException {
        this.bluetoothConnectionHandler.close();
        this.logOpen = false;
    }

    public synchronized void shutdownLoggingService() throws IOException {
        this.bluetoothConnectionHandler.shutdownLoggingService();
        this.logOpen = false;
    }

    public synchronized void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            this.bluetoothConnectionHandler.writeLogToStream(this.formatter.format(this.bluetoothConnectionHandler.getBluetoothClientID(clientID), "", time, level, message, t));
        }
    }

    public synchronized void open() throws IOException {
        this.logOpen = this.bluetoothConnectionHandler.openConnection();
    }

    public long getLogSize() {
        return -1L;
    }

    public synchronized void configure(Properties properties) {
        String serverUrlString = properties.getProperty(SERVER_URL_STRING);
        if (serverUrlString != null && serverUrlString.length() > 0) {
            this.bluetoothConnectionHandler.setConnectionString(serverUrlString);
        }
    }

    public String[] getPropertyNames() {
        return new String[]{BTADDRESS_PROPERTY};
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
        if (name != null && BTADDRESS_PROPERTY.equals(name)) {
            this.bluetoothConnectionHandler.findAndSetConnectionString(BluetoothRemoteDevice.setAddress(value));
        }
    }
}

