/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.bluetooth;

import java.io.DataOutputStream;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import net.sf.microlog.midp.bluetooth.BluetoothConnectionHandler;
import net.sf.microlog.midp.bluetooth.BluetoothRemoteDevice;
import net.sf.microlog.midp.bluetooth.BluetoothServiceSearch;

class BluetoothConnectionHandlerImpl
implements BluetoothConnectionHandler {
    private String connectionString = null;
    private StreamConnection connection = null;
    private DataOutputStream dataOutputStream = null;
    private String bluetoothClientID = null;

    BluetoothConnectionHandlerImpl() {
    }

    private void establishConnectionSelectService() {
        System.err.println("No Server Bluetooth address or Server URL set, using the selectService. Please try to update your code to use a Server Bluetooth address instead!");
        try {
            DiscoveryAgent agent = LocalDevice.getLocalDevice().getDiscoveryAgent();
            this.connectionString = agent.selectService(new UUID("80d41dda939840c41b605d69043dab6", false), 0, false);
        }
        catch (BluetoothStateException bse) {
            System.err.println("Failed to connect to the Bluetooth log server. " + (Object)((Object)bse));
        }
    }

    public void findAndSetConnectionString(BluetoothRemoteDevice remoteDevice) {
        BluetoothServiceSearch serviceSearch = BluetoothServiceSearch.newInstance();
        this.connectionString = serviceSearch.getLoggerServiceString(remoteDevice);
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public boolean openConnection() {
        boolean connectionOpen = false;
        if (this.connectionString == null) {
            this.establishConnectionSelectService();
        }
        try {
            this.openOutputStream();
            connectionOpen = true;
        }
        catch (IOException e) {
            System.err.println("Failed to connect to the Bluetooth log server with connection string " + this.connectionString + ' ' + e);
        }
        return connectionOpen;
    }

    private void openOutputStream() throws IOException {
        if (this.connectionString != null) {
            this.connection = (StreamConnection)Connector.open((String)this.connectionString);
            this.dataOutputStream = this.connection.openDataOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownLoggingService() throws IOException {
        if (this.dataOutputStream != null) {
            try {
                this.dataOutputStream.writeUTF("[STOP]");
            }
            catch (IOException io) {
                System.err.println("Failed to send [STOP] to the Bluetooth server, " + io);
            }
            finally {
                this.close();
            }
        }
    }

    public void close() throws IOException {
        if (this.dataOutputStream != null) {
            try {
                this.dataOutputStream.close();
            }
            catch (IOException e) {
                System.err.println("Failed to terminate the dataOutputStream in a controlled way." + e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                System.err.println("Failed to close the log " + e);
            }
        }
    }

    public void writeLogToStream(String formattedLogStatement) {
        if (this.dataOutputStream != null) {
            try {
                this.dataOutputStream.writeUTF(formattedLogStatement);
                this.dataOutputStream.flush();
            }
            catch (IOException io) {
                System.err.println("Unable to log to the output stream. " + io);
            }
        }
    }

    public String getBluetoothClientID(String clientID) {
        if (this.bluetoothClientID == null) {
            if (clientID == null || clientID.length() == 0) {
                this.bluetoothClientID = this.getBluetoothFriendlyName();
            }
            if (clientID != null || this.bluetoothClientID == null) {
                this.bluetoothClientID = clientID;
            }
        }
        return this.bluetoothClientID;
    }

    private String getBluetoothFriendlyName() {
        String bluetoothFriendlyName = "";
        try {
            bluetoothFriendlyName = LocalDevice.getLocalDevice().getFriendlyName();
        }
        catch (BluetoothStateException bse) {
            System.err.println("Unable to get the Bluetooth friendly name, " + (Object)((Object)bse));
        }
        return bluetoothFriendlyName;
    }
}

