/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.file;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import net.sf.microlog.core.IOUtil;
import net.sf.microlog.core.appender.AbstractAppender;
import net.sf.microlog.core.appender.AbstractFileAppender;

public class FileAppender
extends AbstractFileAppender {
    public static final String FILE_PROTOCOL = "file:///";
    protected FileConnection fileConnection;

    protected String createFileURI() {
        boolean fileNameContainsPath;
        StringBuffer fileURIStringBuffer = new StringBuffer(256);
        fileURIStringBuffer.append(FILE_PROTOCOL);
        boolean bl = fileNameContainsPath = this.fileName.indexOf(47) != -1 || this.fileName.indexOf(92) != -1;
        if (!fileNameContainsPath) {
            this.setDirectoryAsFirstRoot();
        }
        if (this.directory != null) {
            fileURIStringBuffer.append(this.directory);
        }
        fileURIStringBuffer.append(this.fileName);
        String fileURI = fileURIStringBuffer.toString();
        return fileURI;
    }

    private void setDirectoryAsFirstRoot() {
        try {
            Enumeration rootsEnum = FileSystemRegistry.listRoots();
            if (rootsEnum.hasMoreElements()) {
                this.directory = (String)rootsEnum.nextElement();
            } else {
                System.err.println("No root directory is found.");
            }
        }
        catch (SecurityException e) {
            System.err.println("Not allowed to list the roots. " + e);
        }
    }

    protected void createFile(String fileURI) throws IOException {
        this.fileConnection = (FileConnection)Connector.open((String)fileURI, (int)3);
        if (!this.fileConnection.exists()) {
            this.fileConnection.create();
        }
        System.out.println("The created file is " + this.fileConnection.getURL());
    }

    protected synchronized void openOutputStream() throws IOException {
        if (this.fileConnectionIsSet) {
            this.outputStream = this.fileConnection.openOutputStream();
            ((AbstractAppender)this).logOpen = true;
        }
    }

    public synchronized void clear() {
        if (this.fileConnection != null && this.fileConnection.isOpen()) {
            try {
                this.fileConnection.truncate(0L);
            }
            catch (IOException e) {
                System.err.println("Failed to clear the log " + e);
            }
        }
    }

    public synchronized void close() throws IOException {
        if (((AbstractAppender)this).logOpen) {
            IOUtil.closeSilent((OutputStream)this.outputStream);
            IOUtil.closeSilent((Connection)this.fileConnection);
            ((AbstractAppender)this).logOpen = false;
        }
    }

    public synchronized long getLogSize() {
        long logSize = -1L;
        if (((AbstractAppender)this).logOpen) {
            try {
                this.outputStream.flush();
                logSize = this.fileConnection.fileSize();
            }
            catch (IOException e) {
                System.err.println("Failed to get the logsize " + e);
            }
        }
        return logSize;
    }

    public synchronized long totalSize() {
        long totalSize = -1L;
        if (((AbstractAppender)this).logOpen) {
            try {
                this.outputStream.flush();
                totalSize = this.fileConnection.totalSize();
            }
            catch (IOException e) {
                System.err.println("Failed to get the total size." + e);
            }
        }
        return totalSize;
    }

    public synchronized long usedSize() {
        long usedSize = -1L;
        if (((AbstractAppender)this).logOpen) {
            try {
                this.outputStream.flush();
                usedSize = this.fileConnection.usedSize();
            }
            catch (IOException e) {
                System.err.println("Failed to get the total size. " + e);
            }
        }
        return usedSize;
    }

    public synchronized String getURL() {
        String url = "";
        if (this.fileConnection != null) {
            url = this.fileConnection.getURL();
        }
        return url;
    }

    synchronized void setFileConnection(FileConnection fileConnection) {
        this.fileConnection = fileConnection;
        this.fileConnectionIsSet = this.fileConnection != null;
    }
}

