/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.wma;

import java.io.IOException;
import java.io.InterruptedIOException;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.TextMessage;
import net.sf.microlog.midp.wma.AbstractMessageAppender;
import net.sf.microproperties.Properties;

public class SMSBufferAppender
extends AbstractMessageAppender {
    public static final String MESSAGE_RECEIVER_PROPERTY = "messageReceiver";
    public static final String DEFAULT_MESSAGE_RECEIVER = "";
    public static final String[] PROPERTY_NAMES = new String[]{"messageReceiver"};
    public static final String[] DEFAULT_VALUES = new String[]{""};
    private String messageReceiver;

    public SMSBufferAppender() {
        this.lineSeparator = new String(new char[]{'\n'});
    }

    public synchronized void open() throws IOException {
        String connectionString = "sms://" + this.messageReceiver;
        this.openConnection(connectionString);
        this.logOpen = true;
    }

    synchronized void sendLog(String messageContent) {
        if (this.messageReceiver != null) {
            TextMessage message = (TextMessage)this.messageConnection.newMessage("text");
            message.setPayloadText(messageContent);
            try {
                this.messageConnection.send((Message)message);
            }
            catch (InterruptedIOException e) {
                System.err.println("Interrupted while sendinf the log " + e);
            }
            catch (IOException e) {
                System.err.println("Failed to send the log " + e);
            }
        } else {
            System.err.println("A message receiver is not set.");
        }
    }

    public synchronized String getMessageReceiver() {
        return this.messageReceiver;
    }

    public synchronized void setMessageReceiver(String messageReceiver) throws IllegalArgumentException {
        if (messageReceiver == null) {
            throw new IllegalArgumentException("The messageReceiver must not be null");
        }
        this.messageReceiver = messageReceiver;
    }

    public synchronized void configure(Properties properties) {
        String newMessageReceiver;
        if (properties != null && (newMessageReceiver = properties.getProperty(MESSAGE_RECEIVER_PROPERTY)) != null) {
            this.messageReceiver = newMessageReceiver;
        }
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
        super.setProperty(name, value);
        if (name.equals(MESSAGE_RECEIVER_PROPERTY)) {
            this.setMessageReceiver(value);
        }
    }
}

