/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.appender;

import net.sf.microlog.core.Level;
import net.sf.microlog.core.SyslogMessage;
import net.sf.microlog.midp.appender.DatagramAppender;

public class SyslogAppender
extends DatagramAppender {
    String hostname = "127.0.0.1";
    SyslogMessage syslogMessage = new SyslogMessage();

    public SyslogAppender() {
        super.setPort(514);
        this.syslogMessage.setTag("microlog");
        this.syslogMessage.setFacility((byte)1);
        this.syslogMessage.setSeverity((byte)7);
        String hostNameProperty = System.getProperty("microedition.hostname");
        if (hostNameProperty != null && hostNameProperty.length() > 0) {
            this.hostname = hostNameProperty;
        }
    }

    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            this.sendMessage(this.syslogMessage.createMessageData(this.formatter.format(clientID, name, time, level, message, t)));
        }
    }

    public void setFacility(byte facility) {
        this.syslogMessage.setFacility(facility);
    }

    public void setSeverity(byte severity) throws IllegalArgumentException {
        this.syslogMessage.setSeverity(severity);
    }

    public void setHeader(boolean header) {
        this.syslogMessage.setHeader(header);
    }

    public void setHostname(String hostname) throws IllegalArgumentException {
        this.syslogMessage.setHostname(hostname);
    }

    public void setTag(String tag) throws IllegalArgumentException {
        this.syslogMessage.setTag(tag);
    }
}

