/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.appender;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.CommConnection;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import net.sf.microlog.core.IOUtil;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;

public class SerialAppender
extends AbstractAppender {
    public static final String COM_PORT_PROPERTY = "comPort";
    public static final String DEFAULT_COM_PORT = "AT1";
    public static final String[] PROPERTY_NAMES = new String[]{"comPort"};
    private static final String COMM_SCHEME = "comm:";
    private String comPort;
    private CommConnection connection;
    private DataOutputStream dataOutputStream;

    public void setComPort(String comPort) throws IllegalArgumentException {
        if (comPort == null) {
            throw new IllegalArgumentException("The comPort must not be null.");
        }
        this.comPort = comPort;
    }

    public void open() throws IOException {
        if (this.comPort == null) {
            String ports = System.getProperty("microedition.commports");
            int comma = ports.indexOf(44);
            this.comPort = comma > 0 ? ports.substring(0, comma) : ports;
        }
        String connectionString = COMM_SCHEME + this.comPort;
        this.connection = (CommConnection)Connector.open((String)connectionString);
        this.dataOutputStream = this.connection.openDataOutputStream();
        this.logOpen = true;
    }

    public void clear() {
    }

    public void close() throws IOException {
        IOUtil.closeSilent((OutputStream)this.dataOutputStream);
        IOUtil.closeSilent((Connection)this.connection);
        this.logOpen = false;
    }

    public long getLogSize() {
        return -1L;
    }

    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            try {
                this.dataOutputStream.writeUTF(this.formatter.format(clientID, name, time, level, message, t));
                this.dataOutputStream.flush();
            }
            catch (IOException e) {
                System.err.println("Failed to write log data. " + e);
            }
        }
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
        if (name.equals(COM_PORT_PROPERTY)) {
            this.setComPort(value);
        }
    }
}

