/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.appender;

import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import net.sf.microlog.core.IOUtil;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;

public class DatagramAppender
extends AbstractAppender {
    public static final String HOST_PROPERTY = "host";
    public static final String PORT_PROPERTY = "port";
    public static final String[] PROPERTY_NAMES = new String[]{"host", "port"};
    public static final int DEFAULT_DATAGRAM_PORT = 1023;
    static final int DEFAULT_DATAGRAM_SIZE = 128;
    String host = "127.0.0.1";
    int port = 1023;
    private String encoding = "ASCII";
    private int datagramSize = 128;
    protected DatagramConnection connection;
    private Datagram datagram;

    public void open() throws IOException {
        StringBuffer connectionStringBuffer = new StringBuffer(32);
        connectionStringBuffer.append("datagram://");
        connectionStringBuffer.append(this.host);
        connectionStringBuffer.append(':');
        connectionStringBuffer.append(this.port);
        this.connection = (DatagramConnection)Connector.open((String)connectionStringBuffer.toString());
        this.logOpen = true;
    }

    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            String logMessage = this.formatter.format(clientID, name, time, level, message, t);
            this.sendMessage(logMessage);
        }
    }

    protected void sendMessage(String message) {
        try {
            if (this.datagram == null) {
                this.datagram = this.connection.newDatagram(this.datagramSize);
            }
            this.datagram.setData(message.getBytes(this.encoding), 0, message.length());
            this.connection.send(this.datagram);
        }
        catch (IOException e) {
            System.err.println("Could not send the Datagram: " + e);
        }
    }

    public void clear() {
    }

    public void close() throws IOException {
        IOUtil.closeSilent((Connection)this.connection);
        this.logOpen = false;
    }

    public long getLogSize() {
        return -1L;
    }

    public void setHost(String host) throws IllegalArgumentException {
        if (host == null) {
            throw new IllegalArgumentException("The host must not be null.");
        }
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setEncoding(String encoding) throws IllegalArgumentException {
        if (encoding == null || encoding != null && encoding.length() < 1) {
            throw new IllegalArgumentException("The encoding must not be null and the length greater than 1");
        }
        this.encoding = encoding;
    }

    void setConnection(DatagramConnection connection) {
        if (!this.logOpen) {
            this.connection = connection;
        }
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
        if (name.equals(HOST_PROPERTY)) {
            this.setHost(value);
        } else if (name.equals(PORT_PROPERTY)) {
            this.setPort(Integer.parseInt(value));
        }
    }
}

