/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import net.sf.microlog.midp.AscendingComparator;
import net.sf.microlog.midp.DescendingComparator;
import net.sf.microlog.midp.appender.RecordStoreLogNameResolver;
import net.sf.microproperties.Properties;

public class RecordStoreLogLoader {
    private final RecordComparator ascComparator = new AscendingComparator();
    private final RecordComparator descComparator = new DescendingComparator();
    private RecordComparator currentComparator = this.ascComparator;
    private String recordStoreName;
    private RecordStore logRecordStore;

    public RecordStoreLogLoader() {
        this.recordStoreName = RecordStoreLogNameResolver.fetchRecordStoreName(null);
    }

    public RecordStoreLogLoader(Properties properties) {
        this.recordStoreName = RecordStoreLogNameResolver.fetchRecordStoreName(properties);
    }

    public void setRecordStoreName(String recordStoreName) {
        try {
            this.recordStoreName = recordStoreName;
            RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
        }
        catch (RecordStoreFullException e) {
            System.err.println("RecordStore is full." + (Object)((Object)e));
        }
        catch (RecordStoreNotFoundException e) {
            System.err.println("RecordStore does not exists." + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.err.println("RecordStore is not workings." + (Object)((Object)e));
        }
    }

    public String getRecordStoreName() {
        return this.recordStoreName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogContent() {
        StringBuffer logContent = new StringBuffer(512);
        try {
            System.out.println("Reading log data from: " + this.recordStoreName);
            this.logRecordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            RecordEnumeration recordEnum = this.logRecordStore.enumerateRecords(null, this.currentComparator, false);
            while (recordEnum.hasNextElement()) {
                byte[] data = recordEnum.nextRecord();
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    DataInputStream is = new DataInputStream(bais);
                    is.readLong();
                    String logString = is.readUTF();
                    logContent.append(logString + "\n");
                    is.close();
                    bais.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to load log " + e);
                }
            }
            recordEnum.destroy();
        }
        catch (RecordStoreNotFoundException e) {
            System.err.println("Could not find log data in " + this.recordStoreName + " " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.err.println("Could not open log data. " + (Object)((Object)e));
        }
        finally {
            this.closeLog();
        }
        return logContent.toString();
    }

    public void switchSortOrder() {
        this.currentComparator = this.currentComparator instanceof AscendingComparator ? this.descComparator : this.ascComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLog() {
        try {
            this.logRecordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            RecordEnumeration enumeration = this.logRecordStore.enumerateRecords(null, null, false);
            while (enumeration.hasNextElement()) {
                int recordId = enumeration.nextRecordId();
                this.logRecordStore.deleteRecord(recordId);
            }
            this.logRecordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
        }
        catch (RecordStoreNotOpenException e) {
            System.err.println("RecordStore is not open. " + this.recordStoreName + " " + (Object)((Object)e));
        }
        catch (InvalidRecordIDException e) {
            System.err.println("Invalid record id." + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.err.println("RecordStore not working." + (Object)((Object)e));
        }
        finally {
            this.closeLog();
        }
    }

    public int getNumLogItems() {
        int nofLogItems = 0;
        try {
            this.logRecordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            nofLogItems = this.logRecordStore.getNumRecords();
        }
        catch (RecordStoreFullException e) {
            System.err.println("RecordStore is full " + (Object)((Object)e));
        }
        catch (RecordStoreNotFoundException e) {
            System.err.println("RecordStore not found " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.err.println("Some problem with the RecordStore " + (Object)((Object)e));
        }
        return nofLogItems;
    }

    private void closeLog() {
        try {
            if (this.logRecordStore != null) {
                this.logRecordStore.closeRecordStore();
            }
        }
        catch (RecordStoreNotOpenException e) {
            System.err.println("RecordStore was not open " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.err.println("Failed to close the RecordStore " + (Object)((Object)e));
        }
    }
}

