/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.server.btspp.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sf.microlog.midp.bluetooth.BluetoothServerListener;
import net.sf.microlog.midp.bluetooth.server.BluetoothSerialServerThread;
import net.sf.microlog.server.btspp.gui.AboutDialog;

public class MicrologBluetoothServerUI
implements BluetoothServerListener {
    private static final String newline = "\n";
    private final String btAddress;
    public JFrame frame;
    private JTextField serverURLTextField;
    private JLabel statusLabel;
    private List<String> connectedClients = new ArrayList<String>();
    private Object clientConnectionLock = new Object();
    private JTextArea textArea;
    private JList clientList;
    private JScrollPane logScrollPane;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    MicrologBluetoothServerUI window = new MicrologBluetoothServerUI();
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MicrologBluetoothServerUI() {
        this.initialize();
        BluetoothSerialServerThread btThread = new BluetoothSerialServerThread();
        btThread.setServerListener(this);
        this.btAddress = btThread.getLocalBtAddress();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(btThread);
    }

    public void serverStarted(String url) {
        this.getServerURLTextField().setText(url);
        this.getStatusLabel().setText("Running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientAccepted(String address, String name) {
        Object object = this.clientConnectionLock;
        synchronized (object) {
            System.out.println("clientAccepted()");
            this.connectedClients.add(name);
            this.getClientList().setListData(this.connectedClients.toArray());
        }
    }

    public synchronized void messageReceived(String message) {
        if (message != null && message.length() > 0) {
            JTextArea textArea = this.getTextArea();
            textArea.append(message);
            textArea.append(newline);
            textArea.setCaretPosition(textArea.getDocument().getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clientDisconnected(String address, String name) {
        Object object = this.clientConnectionLock;
        synchronized (object) {
            System.out.println("clientDisconnected()");
            this.connectedClients.remove(name);
            this.getClientList().setListData(this.connectedClients.toArray());
        }
    }

    public void shutdown() {
        System.exit(0);
    }

    private void initialize() {
        this.frame = new JFrame();
        this.frame.setTitle("Microlog Bluetooth Server");
        JMenuBar menuBar = new JMenuBar();
        this.frame.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmSaveLogAs = new JMenuItem("Save Log As ...");
        mntmSaveLogAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MicrologBluetoothServerUI.this.showSaveLogFileAsDialog();
            }
        });
        JMenuItem mntmClearLog = new JMenuItem("Clear Log");
        mntmClearLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MicrologBluetoothServerUI.this.getTextArea().setText("");
            }
        });
        mnFile.add(mntmClearLog);
        mnFile.add(mntmSaveLogAs);
        JMenuItem mntmExit = new JMenuItem("Exit");
        mntmExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        mnFile.add(mntmExit);
        JMenu mnHelp = new JMenu("Help");
        menuBar.add(mnHelp);
        JMenuItem mntmBtAddress = new JMenuItem("Server Bluetooth address");
        mntmBtAddress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, MicrologBluetoothServerUI.this.btAddress, "Server Bluetooth address", 1);
            }
        });
        mnHelp.add(mntmBtAddress);
        JMenuItem mntmAbout = new JMenuItem("About");
        mntmAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog aboutDialog = new AboutDialog();
                aboutDialog.setModal(true);
                aboutDialog.setVisible(true);
            }
        });
        mnHelp.add(mntmAbout);
        this.frame.setBounds(100, 100, 793, 499);
        this.frame.setDefaultCloseOperation(3);
        JPanel topPanel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)topPanel.getLayout();
        flowLayout.setAlignment(0);
        this.frame.getContentPane().add((Component)topPanel, "North");
        JLabel lblServerUrl = new JLabel("Server URL:");
        topPanel.add(lblServerUrl);
        this.serverURLTextField = new JTextField();
        this.serverURLTextField.setEditable(false);
        topPanel.add(this.serverURLTextField);
        this.serverURLTextField.setColumns(40);
        JPanel statusPanel = new JPanel();
        flowLayout = (FlowLayout)statusPanel.getLayout();
        flowLayout.setAlignment(0);
        this.frame.getContentPane().add((Component)statusPanel, "South");
        JLabel lblServerStatus = new JLabel("Server Status:");
        statusPanel.add(lblServerStatus);
        this.statusLabel = new JLabel("Not Started");
        statusPanel.add(this.statusLabel);
        JSplitPane splitPane = new JSplitPane();
        this.frame.getContentPane().add((Component)splitPane, "Center");
        JScrollPane clientScrollPane = new JScrollPane();
        splitPane.setLeftComponent(clientScrollPane);
        this.clientList = new JList();
        this.clientList.setListData(this.connectedClients.toArray());
        clientScrollPane.setViewportView(this.clientList);
        this.logScrollPane = new JScrollPane();
        splitPane.setRightComponent(this.logScrollPane);
        this.textArea = new JTextArea();
        this.logScrollPane.setViewportView(this.textArea);
    }

    protected JTextArea getTextArea() {
        return this.textArea;
    }

    private void showSaveLogFileAsDialog() {
        JFileChooser fileChooser = new JFileChooser();
        int returnVal = fileChooser.showSaveDialog(this.frame);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            this.saveLogFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveLogFile(File file) {
        if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (created) {
                    // empty if block
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(file));
            String logText = this.getTextArea().getText();
            output.write(logText);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected JTextField getServerURLTextField() {
        return this.serverURLTextField;
    }

    protected JLabel getStatusLabel() {
        return this.statusLabel;
    }

    protected JList getClientList() {
        return this.clientList;
    }

    protected JScrollPane getLogScrollPane() {
        return this.logScrollPane;
    }
}

