/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core.appender;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;

public abstract class AbstractHttpAppender
extends AbstractAppender {
    protected String postURL;

    public void setPostURL(String postURL) throws IllegalArgumentException {
        if (postURL == null) {
            throw new IllegalArgumentException("The postURL must not be null.");
        }
        this.postURL = postURL;
    }

    public void open() throws IOException {
        this.logOpen = true;
    }

    public void clear() {
    }

    public void close() throws IOException {
        this.logOpen = false;
    }

    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            try {
                OutputStream outputStream = this.connect();
                PrintStream printStream = new PrintStream(outputStream);
                String logString = this.formatter.format(clientID, name, time, level, message, t);
                printStream.print(logString);
                this.getResponse();
                this.disconnect();
            }
            catch (IOException e) {
                System.err.println("Failed to write log to server " + e);
            }
        }
    }

    protected abstract OutputStream connect() throws IOException;

    protected abstract InputStream getResponse() throws IOException;

    protected abstract void disconnect() throws IOException;

    public long getLogSize() {
        return -1L;
    }
}

