/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.appender;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import net.sf.microlog.core.Formatter;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;
import net.sf.microlog.midp.DescendingComparator;

public class RecordStoreAppender
extends AbstractAppender {
    public static final String RECORD_STORE_NAME_PROPERTY = "recordStoreName";
    public static final String RECORD_STORE_MAX_RECORD_STORE_ENTRIES = "maxRecordStoreEntries";
    public static final String[] PROPERTY_NAMES = new String[]{"recordStoreName", "maxRecordStoreEntries"};
    public static final int RECORD_STORE_DEFAULT_MAX_ENTRIES = 20;
    private RecordStore logRecordStore;
    private String recordStoreName = "LogRecordStore";
    private int maxRecordEntries = 20;
    private int currentOldestEntry;
    private int[] limitedRecordIDs;
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
    DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);

    public synchronized String getRecordStoreName() {
        return this.recordStoreName;
    }

    public synchronized void setRecordStoreName(String recordStoreName) throws IllegalArgumentException {
        if (recordStoreName == null) {
            throw new IllegalArgumentException("The recordStoreName must not be null.");
        }
        if (!this.logOpen) {
            this.recordStoreName = recordStoreName;
        }
    }

    public synchronized int getMaxRecordEntries() {
        return this.maxRecordEntries;
    }

    public synchronized void setMaxRecordEntries(int maxRecordEntries) {
        if (!this.logOpen) {
            this.maxRecordEntries = maxRecordEntries;
        }
    }

    public synchronized void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            byte[] data = this.createLogData(clientID, name, time, level, message, t, this.formatter);
            try {
                int newRecId;
                if (this.limitedRecordIDs[this.currentOldestEntry] != -1) {
                    this.logRecordStore.deleteRecord(this.limitedRecordIDs[this.currentOldestEntry]);
                }
                this.limitedRecordIDs[this.currentOldestEntry] = newRecId = this.logRecordStore.addRecord(data, 0, data.length);
                this.currentOldestEntry = (this.currentOldestEntry + 1) % this.maxRecordEntries;
            }
            catch (RecordStoreNotOpenException e) {
                System.err.println("RecordStore was not open " + (Object)((Object)e));
            }
            catch (RecordStoreFullException e) {
                System.err.println("RecordStore is full " + (Object)((Object)e));
            }
            catch (RecordStoreException e) {
                System.err.println("Failed to log to RecordStore " + (Object)((Object)e));
            }
        }
    }

    private synchronized byte[] createLogData(String clientID, String name, long time, Level level, Object message, Throwable t, Formatter formatter) {
        byte[] data = null;
        try {
            this.byteArrayOutputStream.reset();
            this.dataOutputStream.writeLong(time);
            this.dataOutputStream.writeUTF(formatter.format(clientID, name, time, level, message, t));
            data = this.byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            System.err.println("Failed to create the logdata " + e);
        }
        return data;
    }

    public synchronized void clear() {
        try {
            RecordEnumeration enumeration = this.logRecordStore.enumerateRecords(null, null, false);
            while (enumeration.hasNextElement()) {
                int recordId = enumeration.nextRecordId();
                this.logRecordStore.deleteRecord(recordId);
            }
        }
        catch (RecordStoreNotOpenException e) {
            System.err.println("RecordStore not open " + (Object)((Object)e));
        }
        catch (InvalidRecordIDException e) {
            System.err.println("Invalid id " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.err.println("Failed to delete record " + (Object)((Object)e));
        }
    }

    public synchronized void close() throws IOException {
        if (this.logOpen) {
            try {
                this.logRecordStore.closeRecordStore();
            }
            catch (RecordStoreNotOpenException e) {
                throw new IOException("The RecordStore was not open " + (Object)((Object)e));
            }
            catch (RecordStoreException e) {
                throw new IOException("Failed to close the RecordStore " + (Object)((Object)e));
            }
            this.logOpen = false;
        }
    }

    public synchronized void open() throws IOException {
        if (this.recordStoreName == null) {
            this.recordStoreName = "LogRecordStore";
        }
        System.out.println("Log RecordStore: " + this.recordStoreName);
        try {
            this.logRecordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            this.initLimitedEntries();
            this.logOpen = true;
        }
        catch (RecordStoreFullException e) {
            System.err.println("RecordStore is full " + (Object)((Object)e));
        }
        catch (RecordStoreNotFoundException e) {
            System.err.println("RecordStore was not found " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.err.println("Failed to open the log " + (Object)((Object)e));
        }
    }

    public synchronized long getLogSize() {
        long logSize = -1L;
        if (this.logRecordStore != null) {
            try {
                int numRecords = this.logRecordStore.getNumRecords();
                if (numRecords != 0) {
                    logSize = this.logRecordStore.getSize();
                } else if (numRecords == 0) {
                    logSize = 0L;
                }
            }
            catch (RecordStoreNotOpenException e) {
                System.err.println("RecordStore was not open " + (Object)((Object)e));
            }
        }
        return logSize;
    }

    private synchronized void initLimitedEntries() {
        this.limitedRecordIDs = new int[this.maxRecordEntries];
        for (int i = 0; i < this.maxRecordEntries; ++i) {
            this.limitedRecordIDs[i] = -1;
        }
        try {
            int arrayPointer = this.maxRecordEntries - 1;
            if (!this.logOpen) {
                this.logRecordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            }
            RecordEnumeration recordEnum = this.logRecordStore.enumerateRecords(null, (RecordComparator)new DescendingComparator(), false);
            while (recordEnum.hasNextElement()) {
                int recId = recordEnum.nextRecordId();
                if (arrayPointer >= 0) {
                    this.limitedRecordIDs[arrayPointer] = recId;
                    --arrayPointer;
                    continue;
                }
                this.logRecordStore.deleteRecord(recId);
            }
            recordEnum.destroy();
        }
        catch (RecordStoreNotFoundException e) {
            System.err.println("Failed to find recordstore. " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.err.println("Something is wrong with the RecordStore. " + (Object)((Object)e));
        }
    }

    public synchronized String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public synchronized void setProperty(String name, String value) throws IllegalArgumentException {
        super.setProperty(name, value);
        if (name.equals(RECORD_STORE_NAME_PROPERTY)) {
            this.setRecordStoreName(value);
        } else if (name.equals(RECORD_STORE_MAX_RECORD_STORE_ENTRIES)) {
            try {
                this.setMaxRecordEntries(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                System.err.println("Could not parse the property maxRecordStoreEntries : " + value);
            }
        }
    }
}

