/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.appender;

import java.io.IOException;
import javax.microedition.lcdui.Form;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;

public class FormAppender
extends AbstractAppender {
    private static final String DEFAULT_LOGFORM_TITLE = "Microlog Form";
    private Form logForm;
    private long logSize;

    public FormAppender() {
    }

    public FormAppender(Form logForm) throws IllegalArgumentException {
        if (logForm == null) {
            throw new IllegalArgumentException("The logForm must not be null.");
        }
        this.logForm = logForm;
    }

    public final Form getLogForm() {
        return this.logForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogForm(Form logForm) throws IllegalArgumentException {
        if (logForm == null) {
            throw new IllegalArgumentException("The logForm must not be null.");
        }
        Form form = this.logForm;
        synchronized (form) {
            this.logForm = logForm;
            this.logSize = 0L;
        }
    }

    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            this.logForm.append(this.formatter.format(clientID, name, time, level, message, t));
            ++this.logSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.logForm != null) {
            Form form = this.logForm;
            synchronized (form) {
                this.logForm.deleteAll();
                this.logSize = 0L;
            }
        }
    }

    public void close() throws IOException {
        this.logOpen = false;
    }

    public synchronized void open() throws IOException {
        if (this.logForm == null) {
            this.logForm = new Form(DEFAULT_LOGFORM_TITLE);
        }
        this.logOpen = true;
    }

    public long getLogSize() {
        return this.logSize;
    }

    public String[] getPropertyNames() {
        return null;
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
    }
}

