/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.wma;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.wireless.messaging.MessageConnection;
import net.sf.microlog.core.CyclicBuffer;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;

public abstract class AbstractMessageAppender
extends AbstractAppender {
    public static final int DEFAULT_MESSAGE_BUFFER = 255;
    public static final int DEFAULT_BUFFER_SIZE = 10;
    public static final char GSM_7_BIT_LF = '\n';
    private int bufferSize = 10;
    private CyclicBuffer buffer = new CyclicBuffer(10);
    private Level triggerLevel = Level.ERROR;
    protected String lineSeparator = new String(new char[]{'\n'});
    protected MessageConnection messageConnection;

    public abstract void open() throws IOException;

    public synchronized void clear() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }

    public synchronized void close() throws IOException {
        if (this.messageConnection != null) {
            this.messageConnection.close();
        }
        this.logOpen = false;
    }

    public synchronized void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.formatter != null) {
            this.buffer.add((Object)this.formatter.format(clientID, "", time, level, message, t));
        }
        if (level.toInt() >= this.triggerLevel.toInt()) {
            final String messageContent = this.createMessageContent();
            new Thread(new Runnable(){

                public void run() {
                    AbstractMessageAppender.this.sendLog(messageContent);
                }
            }).start();
        }
    }

    abstract void sendLog(String var1);

    protected synchronized void openConnection(String connectionString) throws IOException {
        if (this.messageConnection == null) {
            this.messageConnection = (MessageConnection)Connector.open((String)connectionString);
        }
    }

    protected synchronized String createMessageContent() {
        StringBuffer messageContentBuffer = new StringBuffer(255);
        messageContentBuffer.append("Microlog: ");
        Object currentLogItem = this.buffer.get();
        while (currentLogItem != null) {
            messageContentBuffer.append(currentLogItem);
            if (this.lineSeparator != null) {
                messageContentBuffer.append(this.lineSeparator);
            }
            currentLogItem = this.buffer.get();
        }
        return messageContentBuffer.toString();
    }

    public synchronized long getLogSize() {
        int logSize = 0;
        if (this.buffer != null) {
            this.buffer.length();
        }
        return logSize;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized void setBufferSize(int bufferSize) throws IllegalArgumentException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("The bufferSize must not be less than 1.");
        }
        if (this.buffer == null) {
            this.buffer = new CyclicBuffer(bufferSize);
        } else if (this.buffer != null && bufferSize != this.buffer.getBufferSize()) {
            this.buffer = new CyclicBuffer(bufferSize);
        }
    }

    public Level getTriggerLevel() {
        return this.triggerLevel;
    }

    public void setTriggerLevel(Level triggerLevel) throws IllegalArgumentException {
        if (triggerLevel == null) {
            throw new IllegalArgumentException("The triggerLevel must not be null.");
        }
        this.triggerLevel = triggerLevel;
    }

    public synchronized void setLineSeparator(String lineSeparator) throws IllegalArgumentException {
        if (lineSeparator == null) {
            throw new IllegalArgumentException("The lineSeparator must not be null.");
        }
        this.lineSeparator = lineSeparator;
    }

    synchronized void setMessageConnection(MessageConnection messageConnection) {
        this.messageConnection = messageConnection;
    }
}

