/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.appender;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import net.sf.microlog.core.IOUtil;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.appender.AbstractAppender;

public class SocketAppender
extends AbstractAppender {
    public static final String DEFAULT_SERVER_NAME = "127.0.0.1";
    public static final int DEFAULT_SOCKET_PORT = 1234;
    public static final int DEFAULT_LINGER_TIME = 10;
    public static final String SOCKET_PROTOCOL_STRING = "socket://";
    public static final String SECURE_SOCKET_PROTOCOL_STRING = "ssl://";
    public static final String SERVER_NAME_PROPERTY = "serverName";
    public static final String SOCKET_PORT_PROPERTY = "socketPort";
    public static final String[] PROPERTY_NAMES = new String[]{"serverName", "socketPort"};
    private String protocol = "socket://";
    private String serverName = "127.0.0.1";
    private int port = 1234;
    private int linger = 10;
    private SocketConnection socketConnection;
    private DataOutputStream dataOutputStream;

    public void clear() {
    }

    public synchronized void close() throws IOException {
        IOUtil.closeSilent((OutputStream)this.dataOutputStream);
        IOUtil.closeSilent((Connection)this.socketConnection);
        this.logOpen = false;
    }

    public synchronized void doLog(String clientID, String name, long time, Level level, Object message, Throwable t) {
        if (this.logOpen && this.dataOutputStream != null && this.formatter != null) {
            try {
                this.dataOutputStream.writeUTF(this.formatter.format(clientID, name, time, level, message, t));
            }
            catch (IOException e) {
                this.logOpen = false;
                System.err.println("Could not write data to server " + e + " => closing the log");
            }
        }
    }

    public synchronized void open() throws IOException {
        if (this.socketConnection == null && this.serverName != null) {
            String connectionString = this.protocol + this.serverName + ':' + this.port;
            this.socketConnection = (SocketConnection)Connector.open((String)connectionString);
            this.socketConnection.setSocketOption((byte)1, this.linger);
            this.dataOutputStream = this.socketConnection.openDataOutputStream();
            this.logOpen = true;
        }
    }

    public long getLogSize() {
        return -1L;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) throws IllegalArgumentException {
        if (protocol == null) {
            throw new IllegalArgumentException("The protocol must not be null.");
        }
        if (protocol.compareTo(SOCKET_PROTOCOL_STRING) == 0 || protocol.compareTo(SECURE_SOCKET_PROTOCOL_STRING) == 0) {
            throw new IllegalArgumentException("The protocol must be http:// or https://");
        }
        if (!this.logOpen) {
            this.protocol = protocol;
        }
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized void setPort(int port) {
        if (!this.logOpen) {
            this.port = port;
        }
    }

    public synchronized int getLinger() {
        if (this.socketConnection != null) {
            try {
                this.linger = this.socketConnection.getSocketOption((byte)1);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to get the socket option SocketConnection.LINGER " + e.getMessage());
            }
            catch (IOException e) {
                System.err.println("Failed to get the socket option SocketConnection.LINGER " + e.getMessage());
            }
        }
        return this.linger;
    }

    public synchronized void setLinger(int linger) {
        if (!this.logOpen) {
            this.linger = linger;
        }
    }

    public synchronized String getServerName() {
        return this.serverName;
    }

    public synchronized void setServerName(String serverName) throws IllegalArgumentException {
        if (serverName == null) {
            throw new IllegalArgumentException("The serverName must not be null.");
        }
        if (!this.logOpen) {
            this.serverName = serverName;
        }
    }

    public synchronized void setSocketConnection(SocketConnection socketConnection) throws IllegalArgumentException {
        if (socketConnection == null) {
            throw new IllegalArgumentException("The socketConnection must not be null.");
        }
        this.socketConnection = socketConnection;
    }

    public synchronized DataOutputStream getDataOutputStream() {
        return this.dataOutputStream;
    }

    public synchronized void setDataOutputStream(DataOutputStream dataOutputStream) throws IllegalArgumentException {
        if (dataOutputStream == null) {
            throw new IllegalArgumentException("The dataOutputStream must not be null.");
        }
        if (!this.logOpen) {
            this.dataOutputStream = dataOutputStream;
        }
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
        super.setProperty(name, value);
        if (name.equals(SERVER_NAME_PROPERTY)) {
            this.setServerName(name);
        } else if (name.equals(SOCKET_PORT_PROPERTY)) {
            this.setPort(Integer.parseInt(value));
        }
    }
}

