/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.appender;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import net.sf.microlog.core.Appender;
import net.sf.microlog.core.Formatter;
import net.sf.microlog.core.Level;
import net.sf.microlog.core.format.SimpleFormatter;

public class CanvasAppender
extends Canvas
implements Appender {
    private Vector logStrings = new Vector();
    private Formatter formatter = new SimpleFormatter();
    private boolean isOpen;
    private int lineSize;
    private int screenOffset = 0;
    private Font loggingFont = Font.getFont((int)32, (int)0, (int)8);

    public CanvasAppender() {
        this.lineSize = this.loggingFont.getHeight();
    }

    public void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0, 0, 0);
        int count = 1;
        for (int index = this.screenOffset; index < this.logStrings.size(); ++index) {
            g.drawString(this.logStrings.elementAt(index).toString(), 0, count * this.lineSize, 68);
            ++count;
        }
    }

    protected void keyPressed(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 1: {
                if (this.screenOffset <= 0) break;
                --this.screenOffset;
                break;
            }
            case 6: {
                if (this.lineSize * (this.logStrings.size() - this.screenOffset) <= this.getHeight()) break;
                ++this.screenOffset;
                break;
            }
        }
        this.repaint();
    }

    public void doLog(String clientID, String name, long time, Level level, Object message, Throwable throwable) {
        if (this.isOpen && this.formatter != null) {
            this.logStrings.addElement(this.formatter.format(clientID, name, time, level, message, throwable));
        }
        while (this.lineSize * (this.logStrings.size() - this.screenOffset) > this.getHeight()) {
            ++this.screenOffset;
        }
        this.repaint();
    }

    public void clear() {
        this.logStrings.removeAllElements();
    }

    public void open() throws IOException {
        this.clear();
        this.isOpen = true;
    }

    public void close() throws IOException {
        this.isOpen = false;
    }

    public boolean isLogOpen() {
        return this.isOpen;
    }

    public long getLogSize() {
        return this.logStrings.size();
    }

    public void setFormatter(Formatter formatter) {
        if (formatter == null) {
            throw new NullPointerException("newFormatter is invalid");
        }
        this.formatter = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public String[] getPropertyNames() {
        return null;
    }

    public void setProperty(String name, String value) {
    }
}

