/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.midp.bluetooth;

import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import net.sf.microlog.midp.bluetooth.BluetoothRemoteDevice;

class BluetoothServiceSearch
implements DiscoveryListener {
    private ServiceRecord serviceRecord;
    private boolean serviceSearchCompleted;
    private static final Object lock = new Object();

    private BluetoothServiceSearch() {
    }

    public static BluetoothServiceSearch newInstance() {
        return new BluetoothServiceSearch();
    }

    public String getLoggerServiceString(BluetoothRemoteDevice remoteDevice) {
        return this.getConnectionString(remoteDevice, new UUID("80d41dda939840c41b605d69043dab6", false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConnectionString(BluetoothRemoteDevice remoteDevice, UUID uuid) {
        this.serviceSearchCompleted = false;
        try {
            LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(null, new UUID[]{uuid}, (RemoteDevice)remoteDevice, (DiscoveryListener)this);
            try {
                Object object = lock;
                synchronized (object) {
                    while (!this.serviceSearchCompleted) {
                        lock.wait();
                    }
                }
            }
            catch (InterruptedException ie) {}
        }
        catch (BluetoothStateException bse) {
            System.err.println("Unable to search for the service on device: " + remoteDevice.getBluetoothAddress() + ", " + (Object)((Object)bse));
        }
        String connectionString = this.serviceRecord != null ? this.serviceRecord.getConnectionURL(0, false) : null;
        return connectionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transactionId, int responseCode) {
        Object object = lock;
        synchronized (object) {
            this.serviceSearchCompleted = true;
            lock.notifyAll();
        }
    }

    public void servicesDiscovered(int transactionId, ServiceRecord[] serviceRecords) {
        this.serviceRecord = serviceRecords[0];
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
    }

    public void inquiryCompleted(int type) {
    }
}

